using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table SalesOrderHeader Field`
    /// </summary>
    [Serializable()]
    public class SalesOrderHeaderTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[SalesOrderID]</summary>
        protected Int32 _salesOrderID;
        ///<summary>[SalesOrderID]</summary>
        public Int32 salesOrderID{
            get{return _salesOrderID;}
            set{_salesOrderID = value;}
        }
        ///<summary>[RevisionNumber]</summary>
        protected Byte _revisionNumber;
        ///<summary>[RevisionNumber]</summary>
        public Byte revisionNumber{
            get{return _revisionNumber;}
            set{_revisionNumber = value;}
        }
        ///<summary>[OrderDate]</summary>
        protected DateTime? _orderDate;
        ///<summary>[OrderDate]</summary>
        public DateTime? orderDate{
            get{return _orderDate;}
            set{_orderDate = value;}
        }
        ///<summary>[DueDate]</summary>
        protected DateTime? _dueDate;
        ///<summary>[DueDate]</summary>
        public DateTime? dueDate{
            get{return _dueDate;}
            set{_dueDate = value;}
        }
        ///<summary>[ShipDate]</summary>
        protected DateTime? _shipDate;
        ///<summary>[ShipDate]</summary>
        public DateTime? shipDate{
            get{return _shipDate;}
            set{_shipDate = value;}
        }
        ///<summary>[Status]</summary>
        protected Byte _status;
        ///<summary>[Status]</summary>
        public Byte status{
            get{return _status;}
            set{_status = value;}
        }
        ///<summary>[SalesOrderNumber]</summary>
        protected string _salesOrderNumber;
        ///<summary>[SalesOrderNumber]</summary>
        public string salesOrderNumber{
            get{return _salesOrderNumber;}
            set{_salesOrderNumber = value;}
        }
        ///<summary>[CustomerID]</summary>
        protected Int32 _customerID;
        ///<summary>[CustomerID]</summary>
        public Int32 customerID{
            get{return _customerID;}
            set{_customerID = value;}
        }
        ///<summary>[ShipToAddressID]</summary>
        protected System.Nullable<Int32> _shipToAddressID;
        ///<summary>[ShipToAddressID]</summary>
        public System.Nullable<Int32> shipToAddressID{
            get{return _shipToAddressID;}
            set{_shipToAddressID = value;}
        }
        ///<summary>[BillToAddressID]</summary>
        protected System.Nullable<Int32> _billToAddressID;
        ///<summary>[BillToAddressID]</summary>
        public System.Nullable<Int32> billToAddressID{
            get{return _billToAddressID;}
            set{_billToAddressID = value;}
        }
        ///<summary>[ShipMethod]</summary>
        protected string _shipMethod;
        ///<summary>[ShipMethod]</summary>
        public string shipMethod{
            get{return _shipMethod;}
            set{_shipMethod = value;}
        }
        ///<summary>[CreditCardApprovalCode]</summary>
        protected string _creditCardApprovalCode;
        ///<summary>[CreditCardApprovalCode]</summary>
        public string creditCardApprovalCode{
            get{return _creditCardApprovalCode;}
            set{_creditCardApprovalCode = value;}
        }
        ///<summary>[SubTotal]</summary>
        protected Decimal _subTotal;
        ///<summary>[SubTotal]</summary>
        public Decimal subTotal{
            get{return _subTotal;}
            set{_subTotal = value;}
        }
        ///<summary>[TaxAmt]</summary>
        protected Decimal _taxAmt;
        ///<summary>[TaxAmt]</summary>
        public Decimal taxAmt{
            get{return _taxAmt;}
            set{_taxAmt = value;}
        }
        ///<summary>[Freight]</summary>
        protected Decimal _freight;
        ///<summary>[Freight]</summary>
        public Decimal freight{
            get{return _freight;}
            set{_freight = value;}
        }
        ///<summary>[TotalDue]</summary>
        protected Decimal _totalDue;
        ///<summary>[TotalDue]</summary>
        public Decimal totalDue{
            get{return _totalDue;}
            set{_totalDue = value;}
        }
        ///<summary>[Comment]</summary>
        protected string _comment;
        ///<summary>[Comment]</summary>
        public string comment{
            get{return _comment;}
            set{_comment = value;}
        }
        ///<summary>[ModifiedDate]</summary>
        protected DateTime? _modifiedDate;
        ///<summary>[ModifiedDate]</summary>
        public DateTime? modifiedDate{
            get{return _modifiedDate;}
            set{_modifiedDate = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public SalesOrderHeaderTableRow() : base()
        {
            this._salesOrderID = 0;
            this._revisionNumber = 0;
            this._orderDate = null;
            this._dueDate = null;
            this._shipDate = null;
            this._status = 1;
            this._salesOrderNumber = "";
            this._customerID = 0;
            this._shipToAddressID = null;
            this._billToAddressID = null;
            this._shipMethod = "";
            this._creditCardApprovalCode = "";
            this._subTotal = 0.00M;
            this._taxAmt = 0.00M;
            this._freight = 0.00M;
            this._totalDue = 0;
            this._comment = "";
            this._modifiedDate = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "SalesOrderID"){ this._salesOrderID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "RevisionNumber"){ this._revisionNumber = NumberUtil.Value<Byte>( value );return; }
            if(name ==  "OrderDate"){ this._orderDate = DateUtil.DateValue( value );return; }
            if(name ==  "DueDate"){ this._dueDate = DateUtil.DateValue( value );return; }
            if(name ==  "ShipDate"){ this._shipDate = DateUtil.DateValue( value );return; }
            if(name ==  "Status"){ this._status = NumberUtil.Value<Byte>( value );return; }
            if(name ==  "SalesOrderNumber"){ this._salesOrderNumber = StringUtil.StringValue( value );return; }
            if(name ==  "CustomerID"){ this._customerID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "ShipToAddressID"){ this._shipToAddressID = NumberUtil.Value<Int32?>( value );return; }
            if(name ==  "BillToAddressID"){ this._billToAddressID = NumberUtil.Value<Int32?>( value );return; }
            if(name ==  "ShipMethod"){ this._shipMethod = StringUtil.StringValue( value );return; }
            if(name ==  "CreditCardApprovalCode"){ this._creditCardApprovalCode = StringUtil.StringValue( value );return; }
            if(name ==  "SubTotal"){ this._subTotal = NumberUtil.Value<Decimal>( value );return; }
            if(name ==  "TaxAmt"){ this._taxAmt = NumberUtil.Value<Decimal>( value );return; }
            if(name ==  "Freight"){ this._freight = NumberUtil.Value<Decimal>( value );return; }
            if(name ==  "TotalDue"){ this._totalDue = NumberUtil.Value<Decimal>( value );return; }
            if(name ==  "Comment"){ this._comment = StringUtil.StringValue( value );return; }
            if(name ==  "ModifiedDate"){ this._modifiedDate = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "SalesOrderID") return this._salesOrderID;
            if(name ==  "RevisionNumber") return this._revisionNumber;
            if(name ==  "OrderDate") return this._orderDate;
            if(name ==  "DueDate") return this._dueDate;
            if(name ==  "ShipDate") return this._shipDate;
            if(name ==  "Status") return this._status;
            if(name ==  "SalesOrderNumber") return this._salesOrderNumber;
            if(name ==  "CustomerID") return this._customerID;
            if(name ==  "ShipToAddressID") return this._shipToAddressID;
            if(name ==  "BillToAddressID") return this._billToAddressID;
            if(name ==  "ShipMethod") return this._shipMethod;
            if(name ==  "CreditCardApprovalCode") return this._creditCardApprovalCode;
            if(name ==  "SubTotal") return this._subTotal;
            if(name ==  "TaxAmt") return this._taxAmt;
            if(name ==  "Freight") return this._freight;
            if(name ==  "TotalDue") return this._totalDue;
            if(name ==  "Comment") return this._comment;
            if(name ==  "ModifiedDate") return this._modifiedDate;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            SalesOrderHeaderTableRow clone = new SalesOrderHeaderTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(SalesOrderHeaderTableRow source)
        {
            this.salesOrderID = source.salesOrderID;
            this.revisionNumber = source.revisionNumber;
            this.orderDate = source.orderDate;
            this.dueDate = source.dueDate;
            this.shipDate = source.shipDate;
            this.status = source.status;
            this.salesOrderNumber = source.salesOrderNumber;
            this.customerID = source.customerID;
            this.shipToAddressID = source.shipToAddressID;
            this.billToAddressID = source.billToAddressID;
            this.shipMethod = source.shipMethod;
            this.creditCardApprovalCode = source.creditCardApprovalCode;
            this.subTotal = source.subTotal;
            this.taxAmt = source.taxAmt;
            this.freight = source.freight;
            this.totalDue = source.totalDue;
            this.comment = source.comment;
            this.modifiedDate = source.modifiedDate;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("SalesOrderID")){ this._salesOrderID = NumberUtil.Value<Int32>(row["SalesOrderID"]); }
            if (cols.Contains("RevisionNumber")){ this._revisionNumber = NumberUtil.Value<Byte>(row["RevisionNumber"]); }
            if (cols.Contains("OrderDate")){ this._orderDate = DateUtil.DateValue(row["OrderDate"]); }
            if (cols.Contains("DueDate")){ this._dueDate = DateUtil.DateValue(row["DueDate"]); }
            if (cols.Contains("ShipDate")){ this._shipDate = DateUtil.DateValue(row["ShipDate"]); }
            if (cols.Contains("Status")){ this._status = NumberUtil.Value<Byte>(row["Status"]); }
            if (cols.Contains("SalesOrderNumber")){ this._salesOrderNumber = StringUtil.StringValue(row["SalesOrderNumber"]); }
            if (cols.Contains("CustomerID")){ this._customerID = NumberUtil.Value<Int32>(row["CustomerID"]); }
            if (cols.Contains("ShipToAddressID")){ this._shipToAddressID = NumberUtil.Value<Int32?>(row["ShipToAddressID"]); }
            if (cols.Contains("BillToAddressID")){ this._billToAddressID = NumberUtil.Value<Int32?>(row["BillToAddressID"]); }
            if (cols.Contains("ShipMethod")){ this._shipMethod = StringUtil.StringValue(row["ShipMethod"]); }
            if (cols.Contains("CreditCardApprovalCode")){ this._creditCardApprovalCode = StringUtil.StringValue(row["CreditCardApprovalCode"]); }
            if (cols.Contains("SubTotal")){ this._subTotal = NumberUtil.Value<Decimal>(row["SubTotal"]); }
            if (cols.Contains("TaxAmt")){ this._taxAmt = NumberUtil.Value<Decimal>(row["TaxAmt"]); }
            if (cols.Contains("Freight")){ this._freight = NumberUtil.Value<Decimal>(row["Freight"]); }
            if (cols.Contains("TotalDue")){ this._totalDue = NumberUtil.Value<Decimal>(row["TotalDue"]); }
            if (cols.Contains("Comment")){ this._comment = StringUtil.StringValue(row["Comment"]); }
            if (cols.Contains("ModifiedDate")){ this._modifiedDate = DateUtil.DateValue(row["ModifiedDate"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "SalesOrderID");if (cols.Contains(columnName)){ this._salesOrderID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "RevisionNumber");if (cols.Contains(columnName)){ this._revisionNumber = NumberUtil.Value<Byte>(row[columnName]); }
            columnName = BuildColumnName(alias, "OrderDate");if (cols.Contains(columnName)){ this._orderDate = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DueDate");if (cols.Contains(columnName)){ this._dueDate = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ShipDate");if (cols.Contains(columnName)){ this._shipDate = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "Status");if (cols.Contains(columnName)){ this._status = NumberUtil.Value<Byte>(row[columnName]); }
            columnName = BuildColumnName(alias, "SalesOrderNumber");if (cols.Contains(columnName)){ this._salesOrderNumber = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CustomerID");if (cols.Contains(columnName)){ this._customerID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "ShipToAddressID");if (cols.Contains(columnName)){ this._shipToAddressID = NumberUtil.Value<Int32?>(row[columnName]); }
            columnName = BuildColumnName(alias, "BillToAddressID");if (cols.Contains(columnName)){ this._billToAddressID = NumberUtil.Value<Int32?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ShipMethod");if (cols.Contains(columnName)){ this._shipMethod = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CreditCardApprovalCode");if (cols.Contains(columnName)){ this._creditCardApprovalCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "SubTotal");if (cols.Contains(columnName)){ this._subTotal = NumberUtil.Value<Decimal>(row[columnName]); }
            columnName = BuildColumnName(alias, "TaxAmt");if (cols.Contains(columnName)){ this._taxAmt = NumberUtil.Value<Decimal>(row[columnName]); }
            columnName = BuildColumnName(alias, "Freight");if (cols.Contains(columnName)){ this._freight = NumberUtil.Value<Decimal>(row[columnName]); }
            columnName = BuildColumnName(alias, "TotalDue");if (cols.Contains(columnName)){ this._totalDue = NumberUtil.Value<Decimal>(row[columnName]); }
            columnName = BuildColumnName(alias, "Comment");if (cols.Contains(columnName)){ this._comment = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ModifiedDate");if (cols.Contains(columnName)){ this._modifiedDate = DateUtil.DateValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._salesOrderID = NumberUtil.Value<Int32>(reader[0]);
            this._revisionNumber = NumberUtil.Value<Byte>(reader[1]);
            this._orderDate = DateUtil.DateValue(reader[2]);
            this._dueDate = DateUtil.DateValue(reader[3]);
            this._shipDate = DateUtil.DateValue(reader[4]);
            this._status = NumberUtil.Value<Byte>(reader[5]);
            this._salesOrderNumber = StringUtil.StringValue(reader[6]);
            this._customerID = NumberUtil.Value<Int32>(reader[7]);
            this._shipToAddressID = NumberUtil.Value<Int32?>(reader[8]);
            this._billToAddressID = NumberUtil.Value<Int32?>(reader[9]);
            this._shipMethod = StringUtil.StringValue(reader[10]);
            this._creditCardApprovalCode = StringUtil.StringValue(reader[11]);
            this._subTotal = NumberUtil.Value<Decimal>(reader[12]);
            this._taxAmt = NumberUtil.Value<Decimal>(reader[13]);
            this._freight = NumberUtil.Value<Decimal>(reader[14]);
            this._totalDue = NumberUtil.Value<Decimal>(reader[15]);
            this._comment = StringUtil.StringValue(reader[16]);
            this._modifiedDate = DateUtil.DateValue(reader[17]);
            
            this.IsNew = false;
        }
    }

}