using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.Expressions;

namespace CFWDatabaseTest.Criteria
{
    [TestFixture]
    public class CriteriaTest3
    {
        FieldProperty field1;
        FieldProperty field2;
        FieldProperty field3;
        FieldProperty field4;
        FieldProperty field5;
        FieldProperty field6Sub1;
        FieldProperty field6Sub2;

        CFW.Database.Config.ConnectionConfigElement config;
        CFW.Database.Connection con;

        [NUnit.Framework.SetUp]
        public void init()
        {
            field1 = FieldProperty.NewInstance("int", "test_table3", "field1", "[field1]", 4, 10, 0, false, 0, true);
            field2 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field2]", 50, 0, 0, false, "", false);
            field3 = FieldProperty.NewInstance("datetime", "test_table3", "field3", "[field3]", 16, 23, 3, true, null, false);
            field4 = FieldProperty.NewInstance("decimal", "test_table3", "field4", "[field4]", 12, 10, 2, true, null, false);
            field5 = FieldProperty.NewInstance("smallint", "test_table3", "field5", "[field5]", 2, 5, 0, true, null, false);
            field6Sub1 = FieldProperty.NewInstance("int", "test_table3", "field6_sub1", "[field6_sub1]", 4, 10, 0, true, null, false);
            field6Sub2 = FieldProperty.NewInstance("int", "test_table3", "field6_sub2", "[field6_sub2]", 4, 10, 0, true, null, false);

            config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            con = CFW.Database.ConnectionFactory.GetConnection(config);
        }

        [NUnit.Framework.TearDown]
        public void term()
        {
        }

        [Test]
        public void ComplexConditionTest()
        {

            ComplexCondition condition = new ComplexCondition()
            .add(new ColumnValueCondition(field1, 1, ">="))
            .and( new ColumnValueCondition(field1, 10, "<="))
            .or(new ColumnValueCondition(field1, 100, "<="))
            .or(new ColumnValueCondition(field2, "101010101", "="))
            .or( new ColumnValueCondition(field2, new string[] { "10", "20" }, "IN"))
            .and(new ComplexCondition()
                .add(new ColumnValueCondition(field1, 1, ">="))
                .and( new ColumnValueCondition(field1, 10, "<="))
                .or( new ColumnValueCondition(field1, 100, "<="))
                .or(new ColumnValueCondition(field2, "101010101", "="))
                .or(new ColumnValueCondition(field2, new string[] { "10", "20" }, "IN"))
                .or( new ColumnValueCondition(field2, new string[] { "10", "20" }, "BETWEEN"))
                
            );
            condition.buildExpression();
            string expression = condition.getExpression();
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual("( test_table3.field1 >= @test_table3__field1 AND test_table3.field1 <= @test_table3__field1 OR test_table3.field1 <= @test_table3__field1 OR test_table3.field2 = @test_table3__field2 OR test_table3.field2 IN (@test_table3__field2_0,@test_table3__field2_1) AND ( test_table3.field1 >= @test_table3__field1 AND test_table3.field1 <= @test_table3__field1 OR test_table3.field1 <= @test_table3__field1 OR test_table3.field2 = @test_table3__field2 OR test_table3.field2 IN (@test_table3__field2_0,@test_table3__field2_1) OR test_table3.field2 BETWEEN @test_table3__field2_0 AND @test_table3__field2_1 ) )", expression);

        }
        [Test]
        public void WhereTest()
        {

            ComplexCondition condition = new ComplexCondition()
            .add(new ColumnValueCondition(field1, 1, ">="))
            .add( new ColumnValueCondition(field1, 10, "<="))
            .or(new ColumnValueCondition(field1, 100, "<="))
            .or(new ColumnValueCondition(field2, "101010101", "="))
            .or(new ColumnValueCondition(field2, new string[] { "10", "20" }, "IN"))
            .and(
                new ComplexCondition()
                .add(new ColumnValueCondition(field1, 1, ">="))
                .and(new ColumnValueCondition(field1, 10, "<="))
                .or(new ColumnValueCondition(field1, 100, "<="))
                .or(new ColumnValueCondition(field2, "101010101", "="))
                .or(new ColumnValueCondition(field2, new string[] { "10", "20" }, "IN"))
                .or(new ColumnValueCondition(field2, new string[] { "10", "20" }, "BETWEEN"))
            );

            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(condition);
            c.assemble();

            string expression = c.whereExpression;
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual("( test_table3.field1 >= @test_table3__field1 AND test_table3.field1 <= @test_table3__field1 OR test_table3.field1 <= @test_table3__field1 OR test_table3.field2 = @test_table3__field2 OR test_table3.field2 IN (@test_table3__field2_0,@test_table3__field2_1) AND ( test_table3.field1 >= @test_table3__field1 AND test_table3.field1 <= @test_table3__field1 OR test_table3.field1 <= @test_table3__field1 OR test_table3.field2 = @test_table3__field2 OR test_table3.field2 IN (@test_table3__field2_0,@test_table3__field2_1) OR test_table3.field2 BETWEEN @test_table3__field2_0 AND @test_table3__field2_1 ) )", expression);

        }
        [Test]
        public void WhereTest2()
        {

            CFW.Database.Criteria c = new CFW.Database.Criteria();

            c.where(new ColumnValueCondition(field1, 1, ">="))
                .where(new ColumnValueCondition(field1, 10, "<="))
                .whereOr(new ColumnValueCondition(field1, 100, "<="))
                .whereOr(new ColumnValueCondition(field2, "101010101", "="))
                .whereOr(new ColumnValueCondition(field2, new string[] { "10", "20" }, "IN"));

            c.assemble();

            string expression = c.whereExpression;
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual("test_table3.field1 >= @test_table3__field1 AND test_table3.field1 <= @test_table3__field1 OR test_table3.field1 <= @test_table3__field1 OR test_table3.field2 = @test_table3__field2 OR test_table3.field2 IN (@test_table3__field2_0,@test_table3__field2_1)", expression);

        }
        [Test]
        public void OrderByTest()
        {

            CFW.Database.Criteria c = new CFW.Database.Criteria();

            c.orderBy(field1)
            .orderBy(field2)
            .orderBy(field3)
            .orderBy(field4,"DESC");

            c.assemble();

            string expression = c.orderByExpression;
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual("test_table3.field1 ASC,test_table3.field2 ASC,test_table3.field3 ASC,test_table3.field4 DESC", expression);

        }
        [Test]
        public void OrderByReverse()
        {

            CFW.Database.Criteria c = new CFW.Database.Criteria();

            c.orderBy(field1)
            .orderBy(field2)
            .orderBy(field3)
            .orderBy(field4, "DESC");

            c.assemble(CFW.Database.Criteria.AssembleOption.WITH_ORDER_BY_REVERSE);
            string expression = c.reverseOrderByExpression;
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual("test_table3.field1 DESC,test_table3.field2 DESC,test_table3.field3 DESC,test_table3.field4 ASC", expression);

        }
        [Test]
        public void HavingTest()
        {

            CFW.Database.Criteria c = new CFW.Database.Criteria();

            c.having(new ColumnValueCondition("sum(field1)", 1, ">=","@field1sum"))
            .havingOr(new ColumnValueCondition("sum(field2)", 100, "<=", "@field2sum"));

            c.assemble();

            string expression = c.havingExpression;
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual("sum(field1) >= @field1sum OR sum(field2) <= @field2sum", expression);

        }
        [Test]
        public void GroupByTest()
        {

            CFW.Database.Criteria c = new CFW.Database.Criteria();

            c.groupBy(field1)
            .groupBy(field2)
            .groupBy(field3)
            .groupBy(field4);

            c.assemble();

            string expression = c.groupByExpression;
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual("test_table3.field1,test_table3.field2,test_table3.field3,test_table3.field4", expression);
        }

    }
}
