using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using NUnit.Framework;
using CFW.Database;

namespace CFWDatabaseTest.DbWebServiceReference
{
    [NUnit.Framework.TestFixture]
    public class ExceptionTest    {
        [Test]
        public void ExceptionTest1()
        {
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnectionByName("webService");
            try
            {
                //ǉ
                con.Open();
                CFW.Database.Command command = new CFW.Database.Command("select aaaa from notexiststable");
                //Oo͂Ȃ̂Ŗ߂l
                con.ExecuteQuery(command);
            }
            catch (Exception ex)
            {
                CFW.ErrorHandler.ErrorMessageBuilder bulder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                bulder.WriteLog();
                Assert.IsInstanceOfType(typeof(CFW.Database.ConnectionException), ex);
                CFW.Database.ConnectionException cex = ex as CFW.Database.ConnectionException;
                Assert.IsNotNull(cex);

            }
            finally
            {
                con.Close();
            }
        }
        [Test]
        public void ExceptionTest2()
        {
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnectionByName("webService");
            try
            {
                //ǉ
                con.Open();
                CFW.Database.Command command = new CFW.Database.Command("insert into auth_users (login_id,name,password,description) values(@login_id,@name,@password,@description)");
                command.SetParameter(new CFW.Database.Parameter("@login_id", DbType.String, "m-okada"));
                command.SetParameter(new CFW.Database.Parameter("@name", DbType.String, "webservicetest"));
                command.SetParameter(new CFW.Database.Parameter("@password", DbType.String, "webservicetest"));
                command.SetParameter(new CFW.Database.Parameter("@description", DbType.String, "webservicetest"));
                //Oo͂Ȃ̂Ŗ߂l
                con.ExecuteQuery(command);
            }
            catch (Exception ex)
            {

                CFW.ErrorHandler.ErrorMessageBuilder bulder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                bulder.WriteLog();
                Assert.IsInstanceOfType(typeof(CFW.Database.ConnectionException), ex);
                CFW.Database.ConnectionException cex = ex as CFW.Database.ConnectionException;
                Assert.IsNotNull(cex);
                Assert.AreEqual(2627, cex.ErrorNumber);
            }
            finally
            {
                con.Close();
            }
        }
    }
}
