using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using Newtonsoft;
namespace JsonSerialize
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            CFW.Database.Command command = createCommand();
            sw.Start();
            showCommandAsText(command, textBox1);
            sw.Stop();
            label1.Text = sw.ElapsedMilliseconds.ToString();

        }
        private SerializerBase createSerializer()
        {
            if (radioButton1.Checked) return new Serializer1();

            return new Serializer2();

        }
        private CFW.Database.Command createCommand()
        {
            CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            string query = @"select f1,f2,f3 from table1 where f1=@f1 and f2 between @f2_0 and @f2_1 and name like @name + '%'";
            CFW.Database.Command command = new CFW.Database.Command(query);
            command.SetParameter(new CFW.Database.Parameter("@f1", DbType.String, "1"));
            command.SetParameter(new CFW.Database.Parameter("@f2_0", DbType.String, "A001"));
            command.SetParameter(new CFW.Database.Parameter("@f2_1", DbType.String, "B000"));
            command.SetParameter(new CFW.Database.Parameter("@name", DbType.String, connection.EscapeWildCards("name")));

            return command;
        }
        private void showCommandAsText(CFW.Database.Command command,TextBox displayField)
        {
            SerializerBase serializer = createSerializer();
            displayField.Text = serializer.serialize(command);
        }

        private void deserializeButton_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            CFW.Database.Command command = deserializeCommand();
            sw.Stop();
            showCommandAsText(command, textBox2);
            label1.Text = sw.ElapsedMilliseconds.ToString();

        }
        private CFW.Database.Command deserializeCommand()
        {
            SerializerBase serializer = createSerializer();
            CFW.Database.Command command = serializer.deserialize(textBox1.Text);
            return command;
        }
        private CFW.Database.Command deserializeSimpleParameter()
        {
            return null;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            StringReader baseReader = new StringReader(textBox1.Text);
            Newtonsoft.Json.JsonReader reader = new Newtonsoft.Json.JsonReader(baseReader);
            Newtonsoft.Json.JsonSerializer serializer = new Newtonsoft.Json.JsonSerializer();
            Newtonsoft.Json.JavaScriptObject o = serializer.Deserialize(reader) as Newtonsoft.Json.JavaScriptObject;

            if (o.ContainsKey("param1"))
            {
                System.Diagnostics.Trace.WriteLine("param1 = " + o["param1"].ToString());
            }
            if (o.ContainsKey("param2"))
            {
                System.Diagnostics.Trace.WriteLine("param2 = " + o["param2"].ToString());
            }
            
        }
    }
}