using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Data.Common;
using System.Xml;
using System.Xml.Serialization;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.TableCommand;
using SQLiteSample.Model;
using SQLiteSample.Model.TableRow;
using SQLiteSample.Model.TableProperty;


namespace SQLiteSample.Model.TableAccess
{
    /// <summary>
    /// table[postaldata]ɑ΂鑀
    /// </summary>
    [Serializable()]
    public class PostaldataTableAccess
    {
        /// <summary>
        /// f[^\[Xւ̐ڑ
        /// </summary>
        private Connection connection;
        /// <summary>
        /// postaldataɑΉvpeB
        /// </summary>
        private PostaldataTableProperty property;



#region constructors
        /// <summary>
        /// default construct  gps
        /// </summary>
        private PostaldataTableAccess()
        {
            this.connection = ConnectionFactory.GetConnectionByName("default");
            this.property = new PostaldataTableProperty();
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        public PostaldataTableAccess(Connection db)
        {
            this.connection = db;
            this.property = new  PostaldataTableProperty();
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="db">̐ڑBJĂO</param>
        public PostaldataTableAccess(Connection db, PostaldataTableProperty property)
        {
            this.connection = db;
            this.property = property;
        }
#endregion

#region public interface
        /// <summary>
        /// postaldata֍s̑}
        /// </summary>
        /// <param name="data">}sf[^</param>
        public int Insert(PostaldataTableRow data)
        {
            TableInsertCommand command = BuildInsertCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }

        /// <summary>
        /// postaldata֍s̍XV
        /// </summary>
        /// <param name="data">XVsf[^</param>
        public int Update(PostaldataTableRow data)
        {
            TableUpdateCommand command = BuildUpdateCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// postaldata֍s̍XV
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo</remarks>
        /// <param name="data">XVsf[^</param>
        /// <param name="condition"></param>
        public int Update(PostaldataTableRow data,  TableCommandCondition condition)
        {
            TableUpdateCommand command = BuildUpdateCommand(data,condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// postaldatas̍폜
        /// </summary>
        /// <param name="data">폜sf[^BL[̂݃ZbgłĂOK</param>
        public int Delete(PostaldataTableRow data)
        {
            TableDeleteCommand command = BuildDeleteCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// postaldatas̍폜
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo
        /// <param name="condition"></param>
        public int Delete(TableCommandCondition condition)
        {
            TableDeleteCommand command = BuildDeleteCommand(condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// postaldata̍s݊mF
        /// </summary>
        /// <param name="data">L[ݒ肵f[^</param>
        /// <return>ݒ肵L[ɊYs݂鎞true</return>
        public bool Exists(PostaldataTableRow data)
        {
            TableSelectCommand command = BuildExistsCommand(data);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            int cnt = NumberUtil.IntValue(result.Tables[0].Rows[0][0]);
            if(cnt > 0) return true;
            else return false;
        }
        /// <summary>
        /// postaldata̍s擾
        /// L[1s擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">L[ݒ肵f[^</param>
        public PostaldataTableRow Get(PostaldataTableRow condition)
        {
            TableSelectCommand command = BuildSelectCommand(condition);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            PostaldataTableRow data = null;

            if(result.Tables[0].Rows.Count>0){
                data = new PostaldataTableRow();
                data.FromDataRow(result.Tables[0].Rows[0],"postaldata");
                data.IsNew = false;
            }
            return data;
        }
        /// <summary>
        /// postaldata̍s擾
        /// [U[ݒɊYsׂĎ擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">WHERE</param>
        /// <param name="order">\[g</param>
        public List<PostaldataTableRow> GetList( TableCommandCondition condition,List<TableCommandColumn> order)
        {
            PostaldataTableRow data = null;

            TableSelectCommand command = BuildSelectCommand(condition,order);

            DataSet result = connection.ExecuteQuery(command.GetCommand());
			List<PostaldataTableRow> list = new List<PostaldataTableRow>();
            if(result.Tables[0].Rows.Count>0){
                for (int i = 0; i < result.Tables[0].Rows.Count; i++)
                {
	                data = new PostaldataTableRow();
	                data.FromDataRow(result.Tables[0].Rows[0],"postaldata");
                    data.IsNew = false;
                    list.Add(data);
                }
            }
            return list;
        }
#endregion
        /// <summary>
        /// postaldataւinsert sqlR}h
        /// </summary>
        /// <param name="data">ǉf[^</param>
        public TableInsertCommand BuildInsertCommand(PostaldataTableRow data)
        {
            TableInsertCommand command = new TableInsertCommand("postaldata");

            if (property.Id.DoUpdate) command.AddInsert(property.Id, data.Id);
            if (property.LocalCode.DoUpdate) command.AddInsert(property.LocalCode, data.LocalCode);
            if (property.PostalCode5.DoUpdate) command.AddInsert(property.PostalCode5, data.PostalCode5);
            if (property.PostalCode.DoUpdate) command.AddInsert(property.PostalCode, data.PostalCode);
            if (property.Prefecturek.DoUpdate) command.AddInsert(property.Prefecturek, data.Prefecturek);
            if (property.Cityk.DoUpdate) command.AddInsert(property.Cityk, data.Cityk);
            if (property.Areak.DoUpdate) command.AddInsert(property.Areak, data.Areak);
            if (property.Prefecture.DoUpdate) command.AddInsert(property.Prefecture, data.Prefecture);
            if (property.City.DoUpdate) command.AddInsert(property.City, data.City);
            if (property.Area.DoUpdate) command.AddInsert(property.Area, data.Area);
            if (property.Flag1.DoUpdate) command.AddInsert(property.Flag1, data.Flag1);
            if (property.Flag2.DoUpdate) command.AddInsert(property.Flag2, data.Flag2);
            if (property.Flag3.DoUpdate) command.AddInsert(property.Flag3, data.Flag3);
            if (property.Flag4.DoUpdate) command.AddInsert(property.Flag4, data.Flag4);
            if (property.Flag5.DoUpdate) command.AddInsert(property.Flag5, data.Flag5);
            if (property.Flag6.DoUpdate) command.AddInsert(property.Flag6, data.Flag6);
            
            return command;
        }
        /// <summary>
        /// postaldataւupdate sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        public TableUpdateCommand BuildUpdateCommand(PostaldataTableRow data)
        {
            TableUpdateCommand command = new TableUpdateCommand("postaldata");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.LocalCode.DoUpdate) command.AddUpdate(property.LocalCode, data.LocalCode);
            if (property.PostalCode5.DoUpdate) command.AddUpdate(property.PostalCode5, data.PostalCode5);
            if (property.PostalCode.DoUpdate) command.AddUpdate(property.PostalCode, data.PostalCode);
            if (property.Prefecturek.DoUpdate) command.AddUpdate(property.Prefecturek, data.Prefecturek);
            if (property.Cityk.DoUpdate) command.AddUpdate(property.Cityk, data.Cityk);
            if (property.Areak.DoUpdate) command.AddUpdate(property.Areak, data.Areak);
            if (property.Prefecture.DoUpdate) command.AddUpdate(property.Prefecture, data.Prefecture);
            if (property.City.DoUpdate) command.AddUpdate(property.City, data.City);
            if (property.Area.DoUpdate) command.AddUpdate(property.Area, data.Area);
            if (property.Flag1.DoUpdate) command.AddUpdate(property.Flag1, data.Flag1);
            if (property.Flag2.DoUpdate) command.AddUpdate(property.Flag2, data.Flag2);
            if (property.Flag3.DoUpdate) command.AddUpdate(property.Flag3, data.Flag3);
            if (property.Flag4.DoUpdate) command.AddUpdate(property.Flag4, data.Flag4);
            if (property.Flag5.DoUpdate) command.AddUpdate(property.Flag5, data.Flag5);
            if (property.Flag6.DoUpdate) command.AddUpdate(property.Flag6, data.Flag6);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            
            return command;
        }

        /// <summary>
        /// postaldataւ̍XVSqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        /// <param name="condition">Ώۏ</param>
        public TableUpdateCommand BuildUpdateCommand(PostaldataTableRow data, TableCommandCondition condition)
        {
            TableUpdateCommand command = new TableUpdateCommand("postaldata");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.LocalCode.DoUpdate) command.AddUpdate(property.LocalCode, data.LocalCode);
            if (property.PostalCode5.DoUpdate) command.AddUpdate(property.PostalCode5, data.PostalCode5);
            if (property.PostalCode.DoUpdate) command.AddUpdate(property.PostalCode, data.PostalCode);
            if (property.Prefecturek.DoUpdate) command.AddUpdate(property.Prefecturek, data.Prefecturek);
            if (property.Cityk.DoUpdate) command.AddUpdate(property.Cityk, data.Cityk);
            if (property.Areak.DoUpdate) command.AddUpdate(property.Areak, data.Areak);
            if (property.Prefecture.DoUpdate) command.AddUpdate(property.Prefecture, data.Prefecture);
            if (property.City.DoUpdate) command.AddUpdate(property.City, data.City);
            if (property.Area.DoUpdate) command.AddUpdate(property.Area, data.Area);
            if (property.Flag1.DoUpdate) command.AddUpdate(property.Flag1, data.Flag1);
            if (property.Flag2.DoUpdate) command.AddUpdate(property.Flag2, data.Flag2);
            if (property.Flag3.DoUpdate) command.AddUpdate(property.Flag3, data.Flag3);
            if (property.Flag4.DoUpdate) command.AddUpdate(property.Flag4, data.Flag4);
            if (property.Flag5.DoUpdate) command.AddUpdate(property.Flag5, data.Flag5);
            if (property.Flag6.DoUpdate) command.AddUpdate(property.Flag6, data.Flag6);
            

            //XV`
            if( condition != null ) command.AddWhere(condition);

            return command;
        }

        /// <summary>
        /// postaldataւselect sqlR}h(WHERE͊O炤
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(TableCommandCondition condition)
        {
            TableDeleteCommand command = new TableDeleteCommand("postaldata");


            //XV`
            if (condition != null) command.AddWhere(condition);

            return command;
        }
        /// <summary>
        /// postaldataւdelete sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(PostaldataTableRow data)
        {
            TableDeleteCommand command = new TableDeleteCommand("postaldata");

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// postaldataւselect count(*)(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildExistsCommand(PostaldataTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("postaldata");

            //XV`
            command.AddSelect(new TableCommandColumn("CNT","COUNT(*)"));

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// postaldataւselect sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildSelectCommand(PostaldataTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("postaldata");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.LocalCode);
            command.AddSelect(property.PostalCode5);
            command.AddSelect(property.PostalCode);
            command.AddSelect(property.Prefecturek);
            command.AddSelect(property.Cityk);
            command.AddSelect(property.Areak);
            command.AddSelect(property.Prefecture);
            command.AddSelect(property.City);
            command.AddSelect(property.Area);
            command.AddSelect(property.Flag1);
            command.AddSelect(property.Flag2);
            command.AddSelect(property.Flag3);
            command.AddSelect(property.Flag4);
            command.AddSelect(property.Flag5);
            command.AddSelect(property.Flag6);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// postaldataւselect sqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        /// <param name="order">\[g</param>
        public TableSelectCommand BuildSelectCommand(TableCommandCondition condition,List<TableCommandColumn> order)
        {
            TableSelectCommand command = new TableSelectCommand("postaldata");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.LocalCode);
            command.AddSelect(property.PostalCode5);
            command.AddSelect(property.PostalCode);
            command.AddSelect(property.Prefecturek);
            command.AddSelect(property.Cityk);
            command.AddSelect(property.Areak);
            command.AddSelect(property.Prefecture);
            command.AddSelect(property.City);
            command.AddSelect(property.Area);
            command.AddSelect(property.Flag1);
            command.AddSelect(property.Flag2);
            command.AddSelect(property.Flag3);
            command.AddSelect(property.Flag4);
            command.AddSelect(property.Flag5);
            command.AddSelect(property.Flag6);
            

            //XV`
            if(condition != null)   command.AddWhere(condition);
            //
            if (order != null) command.OrderBy.AddRange(order);

            return command;
        }
        /// <summary>
        /// postaldataselect list
        /// </summary>
        /// <param name="tableAlias">e[uɕtʖ</param>
        /// <param name="columnAliasPrefix">ɕtʖ̐ړ</param>
        public string  GetSelectListString(string tableAlias , string columnAliasPrefix)
        {
        	StringBuilder builder = new StringBuilder();

            //XV`
            builder.AppendLine(", "+ tableAlias + ".id AS " + columnAliasPrefix + "id" );
            builder.AppendLine(", "+ tableAlias + ".local_code AS " + columnAliasPrefix + "local_code" );
            builder.AppendLine(", "+ tableAlias + ".postal_code_5 AS " + columnAliasPrefix + "postal_code_5" );
            builder.AppendLine(", "+ tableAlias + ".postal_code AS " + columnAliasPrefix + "postal_code" );
            builder.AppendLine(", "+ tableAlias + ".prefecture_k AS " + columnAliasPrefix + "prefecture_k" );
            builder.AppendLine(", "+ tableAlias + ".city_k AS " + columnAliasPrefix + "city_k" );
            builder.AppendLine(", "+ tableAlias + ".area_k AS " + columnAliasPrefix + "area_k" );
            builder.AppendLine(", "+ tableAlias + ".prefecture AS " + columnAliasPrefix + "prefecture" );
            builder.AppendLine(", "+ tableAlias + ".city AS " + columnAliasPrefix + "city" );
            builder.AppendLine(", "+ tableAlias + ".area AS " + columnAliasPrefix + "area" );
            builder.AppendLine(", "+ tableAlias + ".flag1 AS " + columnAliasPrefix + "flag1" );
            builder.AppendLine(", "+ tableAlias + ".flag2 AS " + columnAliasPrefix + "flag2" );
            builder.AppendLine(", "+ tableAlias + ".flag3 AS " + columnAliasPrefix + "flag3" );
            builder.AppendLine(", "+ tableAlias + ".flag4 AS " + columnAliasPrefix + "flag4" );
            builder.AppendLine(", "+ tableAlias + ".flag5 AS " + columnAliasPrefix + "flag5" );
            builder.AppendLine(", "+ tableAlias + ".flag6 AS " + columnAliasPrefix + "flag6" );
            

            return builder.ToString().Substring(1);
        }
    }
}
