using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Sample.Model;
using CFW.Sample.Model.TableRow;
using CFW.Sample.Model.TableProperty;

namespace CFW.Sample.Model.TableRow
{
    /// <summary>
    /// table MAST_SITE Field`
    /// </summary>
    [Serializable()]
    public class MastSiteTableRow : CFW.Models.Entity, ICloneable
    {
        ///<summary>[SITE_CODE]</summary>
        protected string _SiteCode;
        ///<summary>[SITE_CODE]</summary>
        public string SiteCode{
            get{return _SiteCode;}
            set{_SiteCode = value;}
        }
        ///<summary>[OPEN_DATE]</summary>
        protected string _OpenDate;
        ///<summary>[OPEN_DATE]</summary>
        public string OpenDate{
            get{return _OpenDate;}
            set{_OpenDate = value;}
        }
        ///<summary>[CLOSE_DATE]</summary>
        protected string _CloseDate;
        ///<summary>[CLOSE_DATE]</summary>
        public string CloseDate{
            get{return _CloseDate;}
            set{_CloseDate = value;}
        }
        ///<summary>[SORT_SEQ]</summary>
        protected System.Nullable<Int16> _SortSeq;
        ///<summary>[SORT_SEQ]</summary>
        public System.Nullable<Int16> SortSeq{
            get{return _SortSeq;}
            set{_SortSeq = value;}
        }
        ///<summary>[NAME]</summary>
        protected string _Name;
        ///<summary>[NAME]</summary>
        public string Name{
            get{return _Name;}
            set{_Name = value;}
        }
        ///<summary>[ANK_NAME]</summary>
        protected string _AnkName;
        ///<summary>[ANK_NAME]</summary>
        public string AnkName{
            get{return _AnkName;}
            set{_AnkName = value;}
        }
        ///<summary>[COMPANY_CODE]</summary>
        protected string _CompanyCode;
        ///<summary>[COMPANY_CODE]</summary>
        public string CompanyCode{
            get{return _CompanyCode;}
            set{_CompanyCode = value;}
        }
        ///<summary>[SITE_URL]</summary>
        protected string _SiteUrl;
        ///<summary>[SITE_URL]</summary>
        public string SiteUrl{
            get{return _SiteUrl;}
            set{_SiteUrl = value;}
        }
        ///<summary>[SITE_URL_OTHER]</summary>
        protected string _SiteUrlOther;
        ///<summary>[SITE_URL_OTHER]</summary>
        public string SiteUrlOther{
            get{return _SiteUrlOther;}
            set{_SiteUrlOther = value;}
        }
        ///<summary>[SITE_CATEGORY1]</summary>
        protected System.Nullable<Int16> _SiteCategory1;
        ///<summary>[SITE_CATEGORY1]</summary>
        public System.Nullable<Int16> SiteCategory1{
            get{return _SiteCategory1;}
            set{_SiteCategory1 = value;}
        }
        ///<summary>[SITE_CATEGORY2]</summary>
        protected System.Nullable<Int16> _SiteCategory2;
        ///<summary>[SITE_CATEGORY2]</summary>
        public System.Nullable<Int16> SiteCategory2{
            get{return _SiteCategory2;}
            set{_SiteCategory2 = value;}
        }
        ///<summary>[DEVICE_CODE]</summary>
        protected Int16 _DeviceCode;
        ///<summary>[DEVICE_CODE]</summary>
        public Int16 DeviceCode{
            get{return _DeviceCode;}
            set{_DeviceCode = value;}
        }
        ///<summary>[MENU_DEVICE_CODE]</summary>
        protected System.Nullable<Int16> _MenuDeviceCode;
        ///<summary>[MENU_DEVICE_CODE]</summary>
        public System.Nullable<Int16> MenuDeviceCode{
            get{return _MenuDeviceCode;}
            set{_MenuDeviceCode = value;}
        }
        ///<summary>[MENU_ADTYPE_CODE]</summary>
        protected System.Nullable<Int16> _MenuAdtypeCode;
        ///<summary>[MENU_ADTYPE_CODE]</summary>
        public System.Nullable<Int16> MenuAdtypeCode{
            get{return _MenuAdtypeCode;}
            set{_MenuAdtypeCode = value;}
        }
        ///<summary>[GOODS_CATEGORY_CODE]</summary>
        protected System.Nullable<Int16> _GoodsCategoryCode;
        ///<summary>[GOODS_CATEGORY_CODE]</summary>
        public System.Nullable<Int16> GoodsCategoryCode{
            get{return _GoodsCategoryCode;}
            set{_GoodsCategoryCode = value;}
        }
        ///<summary>[CARRIER_CODE1]</summary>
        protected System.Nullable<Int16> _CarrierCode1;
        ///<summary>[CARRIER_CODE1]</summary>
        public System.Nullable<Int16> CarrierCode1{
            get{return _CarrierCode1;}
            set{_CarrierCode1 = value;}
        }
        ///<summary>[CARRIER_CODE2]</summary>
        protected System.Nullable<Int16> _CarrierCode2;
        ///<summary>[CARRIER_CODE2]</summary>
        public System.Nullable<Int16> CarrierCode2{
            get{return _CarrierCode2;}
            set{_CarrierCode2 = value;}
        }
        ///<summary>[CARRIER_CODE3]</summary>
        protected System.Nullable<Int16> _CarrierCode3;
        ///<summary>[CARRIER_CODE3]</summary>
        public System.Nullable<Int16> CarrierCode3{
            get{return _CarrierCode3;}
            set{_CarrierCode3 = value;}
        }
        ///<summary>[CARRIER_CODE4]</summary>
        protected System.Nullable<Int16> _CarrierCode4;
        ///<summary>[CARRIER_CODE4]</summary>
        public System.Nullable<Int16> CarrierCode4{
            get{return _CarrierCode4;}
            set{_CarrierCode4 = value;}
        }
        ///<summary>[MEDIA_COST_RATE]</summary>
        protected System.Nullable<Decimal> _MediaCostRate;
        ///<summary>[MEDIA_COST_RATE]</summary>
        public System.Nullable<Decimal> MediaCostRate{
            get{return _MediaCostRate;}
            set{_MediaCostRate = value;}
        }
        ///<summary>[AGENCY_MARGIN_RATE]</summary>
        protected System.Nullable<Decimal> _AgencyMarginRate;
        ///<summary>[AGENCY_MARGIN_RATE]</summary>
        public System.Nullable<Decimal> AgencyMarginRate{
            get{return _AgencyMarginRate;}
            set{_AgencyMarginRate = value;}
        }
        ///<summary>[SP_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _SpOpenFlag;
        ///<summary>[SP_OPEN_FLAG]</summary>
        public System.Nullable<Int16> SpOpenFlag{
            get{return _SpOpenFlag;}
            set{_SpOpenFlag = value;}
        }
        ///<summary>[PM_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _PmOpenFlag;
        ///<summary>[PM_OPEN_FLAG]</summary>
        public System.Nullable<Int16> PmOpenFlag{
            get{return _PmOpenFlag;}
            set{_PmOpenFlag = value;}
        }
        ///<summary>[IO_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _IoOpenFlag;
        ///<summary>[IO_OPEN_FLAG]</summary>
        public System.Nullable<Int16> IoOpenFlag{
            get{return _IoOpenFlag;}
            set{_IoOpenFlag = value;}
        }
        ///<summary>[AD_GUIDE_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _AdGuideOpenFlag;
        ///<summary>[AD_GUIDE_OPEN_FLAG]</summary>
        public System.Nullable<Int16> AdGuideOpenFlag{
            get{return _AdGuideOpenFlag;}
            set{_AdGuideOpenFlag = value;}
        }
        ///<summary>[IMPRESSION]</summary>
        protected System.Nullable<Decimal> _Impression;
        ///<summary>[IMPRESSION]</summary>
        public System.Nullable<Decimal> Impression{
            get{return _Impression;}
            set{_Impression = value;}
        }
        ///<summary>[IMPRESSION_TERM]</summary>
        protected System.Nullable<Int16> _ImpressionTerm;
        ///<summary>[IMPRESSION_TERM]</summary>
        public System.Nullable<Int16> ImpressionTerm{
            get{return _ImpressionTerm;}
            set{_ImpressionTerm = value;}
        }
        ///<summary>[IMPRESSION_TOPPAGE]</summary>
        protected System.Nullable<Decimal> _ImpressionToppage;
        ///<summary>[IMPRESSION_TOPPAGE]</summary>
        public System.Nullable<Decimal> ImpressionToppage{
            get{return _ImpressionToppage;}
            set{_ImpressionToppage = value;}
        }
        ///<summary>[IMPRESSION_TOPPAGE_TERM]</summary>
        protected System.Nullable<Int16> _ImpressionToppageTerm;
        ///<summary>[IMPRESSION_TOPPAGE_TERM]</summary>
        public System.Nullable<Int16> ImpressionToppageTerm{
            get{return _ImpressionToppageTerm;}
            set{_ImpressionToppageTerm = value;}
        }
        ///<summary>[UNIQUE_USER]</summary>
        protected System.Nullable<Decimal> _UniqueUser;
        ///<summary>[UNIQUE_USER]</summary>
        public System.Nullable<Decimal> UniqueUser{
            get{return _UniqueUser;}
            set{_UniqueUser = value;}
        }
        ///<summary>[UNIQUE_USER_TERM]</summary>
        protected System.Nullable<Int16> _UniqueUserTerm;
        ///<summary>[UNIQUE_USER_TERM]</summary>
        public System.Nullable<Int16> UniqueUserTerm{
            get{return _UniqueUserTerm;}
            set{_UniqueUserTerm = value;}
        }
        ///<summary>[UNIQUE_USER_TOPPAGE]</summary>
        protected System.Nullable<Decimal> _UniqueUserToppage;
        ///<summary>[UNIQUE_USER_TOPPAGE]</summary>
        public System.Nullable<Decimal> UniqueUserToppage{
            get{return _UniqueUserToppage;}
            set{_UniqueUserToppage = value;}
        }
        ///<summary>[UNIQUE_USER_TOPPAGE_TERM]</summary>
        protected System.Nullable<Int16> _UniqueUserToppageTerm;
        ///<summary>[UNIQUE_USER_TOPPAGE_TERM]</summary>
        public System.Nullable<Int16> UniqueUserToppageTerm{
            get{return _UniqueUserToppageTerm;}
            set{_UniqueUserToppageTerm = value;}
        }
        ///<summary>[MALE_RATE]</summary>
        protected System.Nullable<Decimal> _MaleRate;
        ///<summary>[MALE_RATE]</summary>
        public System.Nullable<Decimal> MaleRate{
            get{return _MaleRate;}
            set{_MaleRate = value;}
        }
        ///<summary>[FEMALE_RATE]</summary>
        protected System.Nullable<Decimal> _FemaleRate;
        ///<summary>[FEMALE_RATE]</summary>
        public System.Nullable<Decimal> FemaleRate{
            get{return _FemaleRate;}
            set{_FemaleRate = value;}
        }
        ///<summary>[PUBLISHED_YEAR]</summary>
        protected System.Nullable<Int16> _PublishedYear;
        ///<summary>[PUBLISHED_YEAR]</summary>
        public System.Nullable<Int16> PublishedYear{
            get{return _PublishedYear;}
            set{_PublishedYear = value;}
        }
        ///<summary>[PUBLISHED_MONTH]</summary>
        protected System.Nullable<Int16> _PublishedMonth;
        ///<summary>[PUBLISHED_MONTH]</summary>
        public System.Nullable<Int16> PublishedMonth{
            get{return _PublishedMonth;}
            set{_PublishedMonth = value;}
        }
        ///<summary>[PUBLISHED_DAY]</summary>
        protected System.Nullable<Int16> _PublishedDay;
        ///<summary>[PUBLISHED_DAY]</summary>
        public System.Nullable<Int16> PublishedDay{
            get{return _PublishedDay;}
            set{_PublishedDay = value;}
        }
        ///<summary>[PUBLISHED_DATA_KIND]</summary>
        protected System.Nullable<Int16> _PublishedDataKind;
        ///<summary>[PUBLISHED_DATA_KIND]</summary>
        public System.Nullable<Int16> PublishedDataKind{
            get{return _PublishedDataKind;}
            set{_PublishedDataKind = value;}
        }
        ///<summary>[UPPER_SITE_CODE]</summary>
        protected string _UpperSiteCode;
        ///<summary>[UPPER_SITE_CODE]</summary>
        public string UpperSiteCode{
            get{return _UpperSiteCode;}
            set{_UpperSiteCode = value;}
        }
        ///<summary>[PAYMENT_COMPANY]</summary>
        protected string _PaymentCompany;
        ///<summary>[PAYMENT_COMPANY]</summary>
        public string PaymentCompany{
            get{return _PaymentCompany;}
            set{_PaymentCompany = value;}
        }
        ///<summary>[BUSINESS_DIRECT_FLAG]</summary>
        protected System.Nullable<Int16> _BusinessDirectFlag;
        ///<summary>[BUSINESS_DIRECT_FLAG]</summary>
        public System.Nullable<Int16> BusinessDirectFlag{
            get{return _BusinessDirectFlag;}
            set{_BusinessDirectFlag = value;}
        }
        ///<summary>[ADSERVER_FLAG]</summary>
        protected System.Nullable<Int16> _AdserverFlag;
        ///<summary>[ADSERVER_FLAG]</summary>
        public System.Nullable<Int16> AdserverFlag{
            get{return _AdserverFlag;}
            set{_AdserverFlag = value;}
        }
        ///<summary>[SPECIALMENU_FLAG]</summary>
        protected System.Nullable<Int16> _SpecialmenuFlag;
        ///<summary>[SPECIALMENU_FLAG]</summary>
        public System.Nullable<Int16> SpecialmenuFlag{
            get{return _SpecialmenuFlag;}
            set{_SpecialmenuFlag = value;}
        }
        ///<summary>[TOP_OPEN_FLAG]</summary>
        protected System.Nullable<Int16> _TopOpenFlag;
        ///<summary>[TOP_OPEN_FLAG]</summary>
        public System.Nullable<Int16> TopOpenFlag{
            get{return _TopOpenFlag;}
            set{_TopOpenFlag = value;}
        }
        ///<summary>[OPEN_MENU_COUNT]</summary>
        protected System.Nullable<Int16> _OpenMenuCount;
        ///<summary>[OPEN_MENU_COUNT]</summary>
        public System.Nullable<Int16> OpenMenuCount{
            get{return _OpenMenuCount;}
            set{_OpenMenuCount = value;}
        }
        ///<summary>[MAKE_DATE]</summary>
        protected string _MakeDate;
        ///<summary>[MAKE_DATE]</summary>
        public string MakeDate{
            get{return _MakeDate;}
            set{_MakeDate = value;}
        }
        ///<summary>[DOCUMENT_ADDRESS]</summary>
        protected string _DocumentAddress;
        ///<summary>[DOCUMENT_ADDRESS]</summary>
        public string DocumentAddress{
            get{return _DocumentAddress;}
            set{_DocumentAddress = value;}
        }
        ///<summary>[AG_COMPANY_CODE]</summary>
        protected string _AgCompanyCode;
        ///<summary>[AG_COMPANY_CODE]</summary>
        public string AgCompanyCode{
            get{return _AgCompanyCode;}
            set{_AgCompanyCode = value;}
        }
        ///<summary>[INSIDE_OPEN_LEVEL]</summary>
        protected System.Nullable<Int16> _InsideOpenLevel;
        ///<summary>[INSIDE_OPEN_LEVEL]</summary>
        public System.Nullable<Int16> InsideOpenLevel{
            get{return _InsideOpenLevel;}
            set{_InsideOpenLevel = value;}
        }
        ///<summary>[OUTSIDE_OPEN_LEVEL]</summary>
        protected System.Nullable<Int16> _OutsideOpenLevel;
        ///<summary>[OUTSIDE_OPEN_LEVEL]</summary>
        public System.Nullable<Int16> OutsideOpenLevel{
            get{return _OutsideOpenLevel;}
            set{_OutsideOpenLevel = value;}
        }
        ///<summary>[HOME_RATE]</summary>
        protected System.Nullable<Decimal> _HomeRate;
        ///<summary>[HOME_RATE]</summary>
        public System.Nullable<Decimal> HomeRate{
            get{return _HomeRate;}
            set{_HomeRate = value;}
        }
        ///<summary>[WORK_RATE]</summary>
        protected System.Nullable<Decimal> _WorkRate;
        ///<summary>[WORK_RATE]</summary>
        public System.Nullable<Decimal> WorkRate{
            get{return _WorkRate;}
            set{_WorkRate = value;}
        }
        ///<summary>[OVERLAP_RATE]</summary>
        protected System.Nullable<Decimal> _OverlapRate;
        ///<summary>[OVERLAP_RATE]</summary>
        public System.Nullable<Decimal> OverlapRate{
            get{return _OverlapRate;}
            set{_OverlapRate = value;}
        }
        ///<summary>[BUSINESS_REP_DIRECT_FLAG]</summary>
        protected System.Nullable<Int16> _BusinessRepDirectFlag;
        ///<summary>[BUSINESS_REP_DIRECT_FLAG]</summary>
        public System.Nullable<Int16> BusinessRepDirectFlag{
            get{return _BusinessRepDirectFlag;}
            set{_BusinessRepDirectFlag = value;}
        }
        ///<summary>[CLIENT_SITE_FLAG]</summary>
        protected System.Nullable<Int16> _ClientSiteFlag;
        ///<summary>[CLIENT_SITE_FLAG]</summary>
        public System.Nullable<Int16> ClientSiteFlag{
            get{return _ClientSiteFlag;}
            set{_ClientSiteFlag = value;}
        }
        ///<summary>[PRINT_UPPER_SITE_CODE]</summary>
        protected string _PrintUpperSiteCode;
        ///<summary>[PRINT_UPPER_SITE_CODE]</summary>
        public string PrintUpperSiteCode{
            get{return _PrintUpperSiteCode;}
            set{_PrintUpperSiteCode = value;}
        }
        ///<summary>[TEAM_CODE]</summary>
        protected System.Nullable<Int16> _TeamCode;
        ///<summary>[TEAM_CODE]</summary>
        public System.Nullable<Int16> TeamCode{
            get{return _TeamCode;}
            set{_TeamCode = value;}
        }
        ///<summary>[CHECK_NAME]</summary>
        protected string _CheckName;
        ///<summary>[CHECK_NAME]</summary>
        public string CheckName{
            get{return _CheckName;}
            set{_CheckName = value;}
        }
        ///<summary>[VALID_FLAG]</summary>
        protected System.Nullable<Int16> _ValidFlag;
        ///<summary>[VALID_FLAG]</summary>
        public System.Nullable<Int16> ValidFlag{
            get{return _ValidFlag;}
            set{_ValidFlag = value;}
        }
        ///<summary>[INSERT_DATE_TIME]</summary>
        protected object _InsertDateTime;
        ///<summary>[INSERT_DATE_TIME]</summary>
        public object InsertDateTime{
            get{return _InsertDateTime;}
            set{_InsertDateTime = value;}
        }
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        protected string _InsertOperatorCode;
        ///<summary>[INSERT_OPERATOR_CODE]</summary>
        public string InsertOperatorCode{
            get{return _InsertOperatorCode;}
            set{_InsertOperatorCode = value;}
        }
        ///<summary>[UPDATE_DATE_TIME]</summary>
        protected object _UpdateDateTime;
        ///<summary>[UPDATE_DATE_TIME]</summary>
        public object UpdateDateTime{
            get{return _UpdateDateTime;}
            set{_UpdateDateTime = value;}
        }
        ///<summary>[OPERATOR_CODE]</summary>
        protected string _OperatorCode;
        ///<summary>[OPERATOR_CODE]</summary>
        public string OperatorCode{
            get{return _OperatorCode;}
            set{_OperatorCode = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public MastSiteTableRow() : base()
        {
            this._SiteCode = "";
            this._OpenDate = "";
            this._CloseDate = "";
            this._SortSeq = 0;
            this._Name = "";
            this._AnkName = "";
            this._CompanyCode = "";
            this._SiteUrl = "";
            this._SiteUrlOther = "";
            this._SiteCategory1 = 0;
            this._SiteCategory2 = 0;
            this._DeviceCode = 0;
            this._MenuDeviceCode = 0;
            this._MenuAdtypeCode = 0;
            this._GoodsCategoryCode = 0;
            this._CarrierCode1 = 0;
            this._CarrierCode2 = 0;
            this._CarrierCode3 = 0;
            this._CarrierCode4 = 0;
            this._MediaCostRate = 0;
            this._AgencyMarginRate = 0;
            this._SpOpenFlag = 1;
            this._PmOpenFlag = 1;
            this._IoOpenFlag = 0;
            this._AdGuideOpenFlag = 1;
            this._Impression = 0;
            this._ImpressionTerm = 0;
            this._ImpressionToppage = 0;
            this._ImpressionToppageTerm = 0;
            this._UniqueUser = 0;
            this._UniqueUserTerm = 0;
            this._UniqueUserToppage = 0;
            this._UniqueUserToppageTerm = 0;
            this._MaleRate = 0;
            this._FemaleRate = 0;
            this._PublishedYear = 0;
            this._PublishedMonth = 0;
            this._PublishedDay = 0;
            this._PublishedDataKind = 0;
            this._UpperSiteCode = "";
            this._PaymentCompany = "";
            this._BusinessDirectFlag = 0;
            this._AdserverFlag = 0;
            this._SpecialmenuFlag = 0;
            this._TopOpenFlag = 0;
            this._OpenMenuCount = 0;
            this._MakeDate = "";
            this._DocumentAddress = "";
            this._AgCompanyCode = "";
            this._InsideOpenLevel = 1;
            this._OutsideOpenLevel = 1;
            this._HomeRate = 0;
            this._WorkRate = 0;
            this._OverlapRate = 0;
            this._BusinessRepDirectFlag = 0;
            this._ClientSiteFlag = 0;
            this._PrintUpperSiteCode = "";
            this._TeamCode = 0;
            this._CheckName = "";
            this._ValidFlag = 1;
            this._InsertDateTime = null;
            this._InsertOperatorCode = "";
            this._UpdateDateTime = null;
            this._OperatorCode = "";
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "SITE_CODE") this._SiteCode = StringUtil.StringValue( value );
            if(name ==  "OPEN_DATE") this._OpenDate = StringUtil.StringValue( value );
            if(name ==  "CLOSE_DATE") this._CloseDate = StringUtil.StringValue( value );
            if(name ==  "SORT_SEQ") this._SortSeq = NumberUtil.Value<Int16?>( value );
            if(name ==  "NAME") this._Name = StringUtil.StringValue( value );
            if(name ==  "ANK_NAME") this._AnkName = StringUtil.StringValue( value );
            if(name ==  "COMPANY_CODE") this._CompanyCode = StringUtil.StringValue( value );
            if(name ==  "SITE_URL") this._SiteUrl = StringUtil.StringValue( value );
            if(name ==  "SITE_URL_OTHER") this._SiteUrlOther = StringUtil.StringValue( value );
            if(name ==  "SITE_CATEGORY1") this._SiteCategory1 = NumberUtil.Value<Int16?>( value );
            if(name ==  "SITE_CATEGORY2") this._SiteCategory2 = NumberUtil.Value<Int16?>( value );
            if(name ==  "DEVICE_CODE") this._DeviceCode = NumberUtil.Value<Int16>( value );
            if(name ==  "MENU_DEVICE_CODE") this._MenuDeviceCode = NumberUtil.Value<Int16?>( value );
            if(name ==  "MENU_ADTYPE_CODE") this._MenuAdtypeCode = NumberUtil.Value<Int16?>( value );
            if(name ==  "GOODS_CATEGORY_CODE") this._GoodsCategoryCode = NumberUtil.Value<Int16?>( value );
            if(name ==  "CARRIER_CODE1") this._CarrierCode1 = NumberUtil.Value<Int16?>( value );
            if(name ==  "CARRIER_CODE2") this._CarrierCode2 = NumberUtil.Value<Int16?>( value );
            if(name ==  "CARRIER_CODE3") this._CarrierCode3 = NumberUtil.Value<Int16?>( value );
            if(name ==  "CARRIER_CODE4") this._CarrierCode4 = NumberUtil.Value<Int16?>( value );
            if(name ==  "MEDIA_COST_RATE") this._MediaCostRate = NumberUtil.Value<Decimal?>( value );
            if(name ==  "AGENCY_MARGIN_RATE") this._AgencyMarginRate = NumberUtil.Value<Decimal?>( value );
            if(name ==  "SP_OPEN_FLAG") this._SpOpenFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "PM_OPEN_FLAG") this._PmOpenFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "IO_OPEN_FLAG") this._IoOpenFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "AD_GUIDE_OPEN_FLAG") this._AdGuideOpenFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "IMPRESSION") this._Impression = NumberUtil.Value<Decimal?>( value );
            if(name ==  "IMPRESSION_TERM") this._ImpressionTerm = NumberUtil.Value<Int16?>( value );
            if(name ==  "IMPRESSION_TOPPAGE") this._ImpressionToppage = NumberUtil.Value<Decimal?>( value );
            if(name ==  "IMPRESSION_TOPPAGE_TERM") this._ImpressionToppageTerm = NumberUtil.Value<Int16?>( value );
            if(name ==  "UNIQUE_USER") this._UniqueUser = NumberUtil.Value<Decimal?>( value );
            if(name ==  "UNIQUE_USER_TERM") this._UniqueUserTerm = NumberUtil.Value<Int16?>( value );
            if(name ==  "UNIQUE_USER_TOPPAGE") this._UniqueUserToppage = NumberUtil.Value<Decimal?>( value );
            if(name ==  "UNIQUE_USER_TOPPAGE_TERM") this._UniqueUserToppageTerm = NumberUtil.Value<Int16?>( value );
            if(name ==  "MALE_RATE") this._MaleRate = NumberUtil.Value<Decimal?>( value );
            if(name ==  "FEMALE_RATE") this._FemaleRate = NumberUtil.Value<Decimal?>( value );
            if(name ==  "PUBLISHED_YEAR") this._PublishedYear = NumberUtil.Value<Int16?>( value );
            if(name ==  "PUBLISHED_MONTH") this._PublishedMonth = NumberUtil.Value<Int16?>( value );
            if(name ==  "PUBLISHED_DAY") this._PublishedDay = NumberUtil.Value<Int16?>( value );
            if(name ==  "PUBLISHED_DATA_KIND") this._PublishedDataKind = NumberUtil.Value<Int16?>( value );
            if(name ==  "UPPER_SITE_CODE") this._UpperSiteCode = StringUtil.StringValue( value );
            if(name ==  "PAYMENT_COMPANY") this._PaymentCompany = StringUtil.StringValue( value );
            if(name ==  "BUSINESS_DIRECT_FLAG") this._BusinessDirectFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "ADSERVER_FLAG") this._AdserverFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "SPECIALMENU_FLAG") this._SpecialmenuFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "TOP_OPEN_FLAG") this._TopOpenFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "OPEN_MENU_COUNT") this._OpenMenuCount = NumberUtil.Value<Int16?>( value );
            if(name ==  "MAKE_DATE") this._MakeDate = StringUtil.StringValue( value );
            if(name ==  "DOCUMENT_ADDRESS") this._DocumentAddress = StringUtil.StringValue( value );
            if(name ==  "AG_COMPANY_CODE") this._AgCompanyCode = StringUtil.StringValue( value );
            if(name ==  "INSIDE_OPEN_LEVEL") this._InsideOpenLevel = NumberUtil.Value<Int16?>( value );
            if(name ==  "OUTSIDE_OPEN_LEVEL") this._OutsideOpenLevel = NumberUtil.Value<Int16?>( value );
            if(name ==  "HOME_RATE") this._HomeRate = NumberUtil.Value<Decimal?>( value );
            if(name ==  "WORK_RATE") this._WorkRate = NumberUtil.Value<Decimal?>( value );
            if(name ==  "OVERLAP_RATE") this._OverlapRate = NumberUtil.Value<Decimal?>( value );
            if(name ==  "BUSINESS_REP_DIRECT_FLAG") this._BusinessRepDirectFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "CLIENT_SITE_FLAG") this._ClientSiteFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "PRINT_UPPER_SITE_CODE") this._PrintUpperSiteCode = StringUtil.StringValue( value );
            if(name ==  "TEAM_CODE") this._TeamCode = NumberUtil.Value<Int16?>( value );
            if(name ==  "CHECK_NAME") this._CheckName = StringUtil.StringValue( value );
            if(name ==  "VALID_FLAG") this._ValidFlag = NumberUtil.Value<Int16?>( value );
            if(name ==  "INSERT_DATE_TIME") this._InsertDateTime = DateUtil.DateValue( value );
            if(name ==  "INSERT_OPERATOR_CODE") this._InsertOperatorCode = StringUtil.StringValue( value );
            if(name ==  "UPDATE_DATE_TIME") this._UpdateDateTime = DateUtil.DateValue( value );
            if(name ==  "OPERATOR_CODE") this._OperatorCode = StringUtil.StringValue( value );
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "SITE_CODE") return this._SiteCode;
            if(name ==  "OPEN_DATE") return this._OpenDate;
            if(name ==  "CLOSE_DATE") return this._CloseDate;
            if(name ==  "SORT_SEQ") return this._SortSeq;
            if(name ==  "NAME") return this._Name;
            if(name ==  "ANK_NAME") return this._AnkName;
            if(name ==  "COMPANY_CODE") return this._CompanyCode;
            if(name ==  "SITE_URL") return this._SiteUrl;
            if(name ==  "SITE_URL_OTHER") return this._SiteUrlOther;
            if(name ==  "SITE_CATEGORY1") return this._SiteCategory1;
            if(name ==  "SITE_CATEGORY2") return this._SiteCategory2;
            if(name ==  "DEVICE_CODE") return this._DeviceCode;
            if(name ==  "MENU_DEVICE_CODE") return this._MenuDeviceCode;
            if(name ==  "MENU_ADTYPE_CODE") return this._MenuAdtypeCode;
            if(name ==  "GOODS_CATEGORY_CODE") return this._GoodsCategoryCode;
            if(name ==  "CARRIER_CODE1") return this._CarrierCode1;
            if(name ==  "CARRIER_CODE2") return this._CarrierCode2;
            if(name ==  "CARRIER_CODE3") return this._CarrierCode3;
            if(name ==  "CARRIER_CODE4") return this._CarrierCode4;
            if(name ==  "MEDIA_COST_RATE") return this._MediaCostRate;
            if(name ==  "AGENCY_MARGIN_RATE") return this._AgencyMarginRate;
            if(name ==  "SP_OPEN_FLAG") return this._SpOpenFlag;
            if(name ==  "PM_OPEN_FLAG") return this._PmOpenFlag;
            if(name ==  "IO_OPEN_FLAG") return this._IoOpenFlag;
            if(name ==  "AD_GUIDE_OPEN_FLAG") return this._AdGuideOpenFlag;
            if(name ==  "IMPRESSION") return this._Impression;
            if(name ==  "IMPRESSION_TERM") return this._ImpressionTerm;
            if(name ==  "IMPRESSION_TOPPAGE") return this._ImpressionToppage;
            if(name ==  "IMPRESSION_TOPPAGE_TERM") return this._ImpressionToppageTerm;
            if(name ==  "UNIQUE_USER") return this._UniqueUser;
            if(name ==  "UNIQUE_USER_TERM") return this._UniqueUserTerm;
            if(name ==  "UNIQUE_USER_TOPPAGE") return this._UniqueUserToppage;
            if(name ==  "UNIQUE_USER_TOPPAGE_TERM") return this._UniqueUserToppageTerm;
            if(name ==  "MALE_RATE") return this._MaleRate;
            if(name ==  "FEMALE_RATE") return this._FemaleRate;
            if(name ==  "PUBLISHED_YEAR") return this._PublishedYear;
            if(name ==  "PUBLISHED_MONTH") return this._PublishedMonth;
            if(name ==  "PUBLISHED_DAY") return this._PublishedDay;
            if(name ==  "PUBLISHED_DATA_KIND") return this._PublishedDataKind;
            if(name ==  "UPPER_SITE_CODE") return this._UpperSiteCode;
            if(name ==  "PAYMENT_COMPANY") return this._PaymentCompany;
            if(name ==  "BUSINESS_DIRECT_FLAG") return this._BusinessDirectFlag;
            if(name ==  "ADSERVER_FLAG") return this._AdserverFlag;
            if(name ==  "SPECIALMENU_FLAG") return this._SpecialmenuFlag;
            if(name ==  "TOP_OPEN_FLAG") return this._TopOpenFlag;
            if(name ==  "OPEN_MENU_COUNT") return this._OpenMenuCount;
            if(name ==  "MAKE_DATE") return this._MakeDate;
            if(name ==  "DOCUMENT_ADDRESS") return this._DocumentAddress;
            if(name ==  "AG_COMPANY_CODE") return this._AgCompanyCode;
            if(name ==  "INSIDE_OPEN_LEVEL") return this._InsideOpenLevel;
            if(name ==  "OUTSIDE_OPEN_LEVEL") return this._OutsideOpenLevel;
            if(name ==  "HOME_RATE") return this._HomeRate;
            if(name ==  "WORK_RATE") return this._WorkRate;
            if(name ==  "OVERLAP_RATE") return this._OverlapRate;
            if(name ==  "BUSINESS_REP_DIRECT_FLAG") return this._BusinessRepDirectFlag;
            if(name ==  "CLIENT_SITE_FLAG") return this._ClientSiteFlag;
            if(name ==  "PRINT_UPPER_SITE_CODE") return this._PrintUpperSiteCode;
            if(name ==  "TEAM_CODE") return this._TeamCode;
            if(name ==  "CHECK_NAME") return this._CheckName;
            if(name ==  "VALID_FLAG") return this._ValidFlag;
            if(name ==  "INSERT_DATE_TIME") return this._InsertDateTime;
            if(name ==  "INSERT_OPERATOR_CODE") return this._InsertOperatorCode;
            if(name ==  "UPDATE_DATE_TIME") return this._UpdateDateTime;
            if(name ==  "OPERATOR_CODE") return this._OperatorCode;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            MastSiteTableRow clone = new MastSiteTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(MastSiteTableRow source)
        {
            this.SiteCode = source.SiteCode;
            this.OpenDate = source.OpenDate;
            this.CloseDate = source.CloseDate;
            this.SortSeq = source.SortSeq;
            this.Name = source.Name;
            this.AnkName = source.AnkName;
            this.CompanyCode = source.CompanyCode;
            this.SiteUrl = source.SiteUrl;
            this.SiteUrlOther = source.SiteUrlOther;
            this.SiteCategory1 = source.SiteCategory1;
            this.SiteCategory2 = source.SiteCategory2;
            this.DeviceCode = source.DeviceCode;
            this.MenuDeviceCode = source.MenuDeviceCode;
            this.MenuAdtypeCode = source.MenuAdtypeCode;
            this.GoodsCategoryCode = source.GoodsCategoryCode;
            this.CarrierCode1 = source.CarrierCode1;
            this.CarrierCode2 = source.CarrierCode2;
            this.CarrierCode3 = source.CarrierCode3;
            this.CarrierCode4 = source.CarrierCode4;
            this.MediaCostRate = source.MediaCostRate;
            this.AgencyMarginRate = source.AgencyMarginRate;
            this.SpOpenFlag = source.SpOpenFlag;
            this.PmOpenFlag = source.PmOpenFlag;
            this.IoOpenFlag = source.IoOpenFlag;
            this.AdGuideOpenFlag = source.AdGuideOpenFlag;
            this.Impression = source.Impression;
            this.ImpressionTerm = source.ImpressionTerm;
            this.ImpressionToppage = source.ImpressionToppage;
            this.ImpressionToppageTerm = source.ImpressionToppageTerm;
            this.UniqueUser = source.UniqueUser;
            this.UniqueUserTerm = source.UniqueUserTerm;
            this.UniqueUserToppage = source.UniqueUserToppage;
            this.UniqueUserToppageTerm = source.UniqueUserToppageTerm;
            this.MaleRate = source.MaleRate;
            this.FemaleRate = source.FemaleRate;
            this.PublishedYear = source.PublishedYear;
            this.PublishedMonth = source.PublishedMonth;
            this.PublishedDay = source.PublishedDay;
            this.PublishedDataKind = source.PublishedDataKind;
            this.UpperSiteCode = source.UpperSiteCode;
            this.PaymentCompany = source.PaymentCompany;
            this.BusinessDirectFlag = source.BusinessDirectFlag;
            this.AdserverFlag = source.AdserverFlag;
            this.SpecialmenuFlag = source.SpecialmenuFlag;
            this.TopOpenFlag = source.TopOpenFlag;
            this.OpenMenuCount = source.OpenMenuCount;
            this.MakeDate = source.MakeDate;
            this.DocumentAddress = source.DocumentAddress;
            this.AgCompanyCode = source.AgCompanyCode;
            this.InsideOpenLevel = source.InsideOpenLevel;
            this.OutsideOpenLevel = source.OutsideOpenLevel;
            this.HomeRate = source.HomeRate;
            this.WorkRate = source.WorkRate;
            this.OverlapRate = source.OverlapRate;
            this.BusinessRepDirectFlag = source.BusinessRepDirectFlag;
            this.ClientSiteFlag = source.ClientSiteFlag;
            this.PrintUpperSiteCode = source.PrintUpperSiteCode;
            this.TeamCode = source.TeamCode;
            this.CheckName = source.CheckName;
            this.ValidFlag = source.ValidFlag;
            this.InsertDateTime = source.InsertDateTime;
            this.InsertOperatorCode = source.InsertOperatorCode;
            this.UpdateDateTime = source.UpdateDateTime;
            this.OperatorCode = source.OperatorCode;
            
        }
    }

}