using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using CFW.Util;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Windows.Forms;
using CFW.Windows.Forms.Adapters;

namespace WindowsApplicationSample1
{
    public class Form2Input : FormAdapter
    {
        public CFW.Sample.Table.TestTable3Table data;

        public FormAdapterElement field1;
        public FormAdapterElement field2;
        public FormAdapterElement field3;
        public FormAdapterElement field4;
        public FormAdapterElement field5;
        public FormAdapterElement field6Sub1;
        public FormAdapterElement field6Sub2;

        public Form2Input() : base()
        {

        }

        public override bool Validate()
        {
            bool valid = true;
            if (!this.field1.Validate())
            {
                valid = false;
            }
            if (!this.field2.Validate())
            {
                valid = false;
            }
            if (!this.field3.Validate())
            {
                valid = false;
            }
            if (!this.field4.Validate())
            {
                valid = false;
            }
            if (!this.field5.Validate())
            {
                valid = false;
            }
            if (!this.field6Sub1.Validate())
            {
                valid = false;
            }
            if (!this.field6Sub2.Validate())
            {
                valid = false;
            }
            return valid;
        }

        public override void UpdateFields()
        {
            this.field1.UpdateField();
            this.field2.UpdateField();
            this.field3.UpdateField();
            this.field4.UpdateField();
            this.field5.UpdateField();
            this.field6Sub1.UpdateField();
            this.field6Sub2.UpdateField();
        }

        public override void RenderView()
        {
            this.field1.Render();
            this.field2.Render();
            this.field3.Render();
            this.field4.Render();
            this.field5.Render();
            this.field6Sub1.Render();
            this.field6Sub2.Render();
        }
        public override CFW.Models.Entity GetEntity()
        {

            return this.data;
        }

        public override void SetEntity(CFW.Models.Entity data)
        {
            this.data = (CFW.Sample.Table.TestTable3Table)data;
            this.field1.SetValue(this.data.Field1);
            this.field2.SetValue(this.data.Field2);
            this.field3.SetValue(this.data.Field3);
            this.field4.SetValue(this.data.Field4);
            this.field5.SetValue(this.data.Field5);
            this.field6Sub1.SetValue(this.data.Field6Sub1);
            this.field6Sub2.SetValue(this.data.Field6Sub2);

        }


        public override void UpdateEntity()
        {
            this.data.Field1 = NumberUtil.Value<int>(field1.GetValue());
            this.data.Field2 = StringUtil.StringValue(field2.GetValue());
            this.data.Field3 = DateUtil.DateValue(field3.GetValue());
            this.data.Field4 = NumberUtil.Value<decimal?>(field4.GetValue());
            this.data.Field5 = NumberUtil.Value<short?>(field5.GetValue());
            this.data.Field6Sub1 = NumberUtil.Value<int?>(field6Sub1.GetValue());
            this.data.Field6Sub2 = NumberUtil.Value<int?>(field6Sub2.GetValue());


        }

    }
}
