using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Forms;
using CFW.Forms.Filters;

namespace WindowsApplicationSample1.FormAdapterTest
{
    public partial class GcDropDownListFormAdapterTest : Form
    {

        TestProperty property;

        FormAdapterTest.StringEntity entity;
        FormAdapterTest.GcTextFormAdapter formAdapter;

        public GcDropDownListFormAdapterTest()
        {
            InitializeComponent();
            /*
             * data source 
             */
            gcComboBox1.Items.Add("f1");
            gcComboBox1.Items.Add("f2");
            gcComboBox1.Items.Add("f3");
            gcComboBox1.Items.Add("f4");

            gcComboBox2.Items.Add("f1");
            gcComboBox2.Items[0].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f001"));
            gcComboBox2.Items.Add("f2");
            gcComboBox2.Items[1].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f002"));
            gcComboBox2.Items.Add("f3");
            gcComboBox2.Items[2].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f003"));
            gcComboBox2.Items.Add("f4");
            gcComboBox2.Items[3].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f004"));

            gcComboBox3.Items.Add("f1");
            gcComboBox3.Items[0].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f001"));
            gcComboBox3.Items.Add("f2");
            gcComboBox3.Items[1].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f002"));
            gcComboBox3.Items.Add("f3");
            gcComboBox3.Items[2].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f003"));
            gcComboBox3.Items.Add("f4");
            gcComboBox3.Items[3].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f004"));



            List<StringEntity> dataSource = new List<StringEntity>();
            StringEntity e1 = new StringEntity();
            e1.Field1 = "K001";
            e1.Field2 = "TEXT001";
            dataSource.Add(e1);

            e1 = new StringEntity();
            e1.Field1 = "K002";
            e1.Field2 = "TEXT002";
            dataSource.Add(e1);
            e1 = new StringEntity();
            e1.Field1 = "K003";
            e1.Field2 = "TEXT003";
            dataSource.Add(e1);

            gcComboBox4.AutoGenerateColumns = true;
            gcComboBox4.DataSource = dataSource;
            gcComboBox4.TextSubItemIndex = 1;
            
            /*
             * }bsO
             */
            entity = new StringEntity();
            property = new TestProperty();
            formAdapter = new GcTextFormAdapter();

            property.Field1 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field1]", 50, 0, 0, false, "", false);
            property.Field2 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field2]", 10, 0, 0, false, "", false);
            property.Field3 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field3]", 20, 0, 0, false, "", false);
            property.Field4 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field4]", 30, 0, 0, false, "", false);
            property.Field5 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field5]", 40, 0, 0, false, "", false);

            formAdapter.element1 = new CFW.Windows.Forms.Adapters.GcDropDownListAdapterElement(
                this.gcComboBox1,
                0,
                0
            );
            formAdapter.element2 = new CFW.Windows.Forms.Adapters.GcDropDownListAdapterElement(
                this.gcComboBox2,
                0,
                1
            );
            formAdapter.element3 = new CFW.Windows.Forms.Adapters.GcDropDownListAdapterElement(
                this.gcComboBox3,
                1,
                0
            );
            formAdapter.element4 = new CFW.Windows.Forms.Adapters.GcDropDownListAdapterElement(
                this.gcComboBox4,
                1,
                0
            );

            formAdapter.SetEntity(this.entity);
            formAdapter.RenderView();

            
        }

        private void button1_Click(object sender, EventArgs e)
        {
            formAdapter.Bind();

            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.AppendLine(formAdapter.element1.ErrorMessage);
            messageBuilder.AppendLine(formAdapter.element2.ErrorMessage);
            messageBuilder.AppendLine(formAdapter.element3.ErrorMessage);
            messageBuilder.AppendLine(formAdapter.element4.ErrorMessage);


            this.validationMessage.Text = messageBuilder.ToString();
            if (formAdapter.IsValid)
            {
                StringEntity entity = (StringEntity)formAdapter.GetEntity();
                StringBuilder valuesBuilder = new StringBuilder();
                valuesBuilder.AppendLine("field1=" + entity.Field1);
                valuesBuilder.AppendLine("field2=" + entity.Field2);
                valuesBuilder.AppendLine("field3=" + entity.Field3);
                valuesBuilder.AppendLine("field4=" + entity.Field4);

                valuesText.Text = valuesBuilder.ToString();

            }



        }
    }
}