using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.Database;
using CFW.Database.TableCommand;
using CFW.Sample.Model2.TableValidator;
using CFW.Sample.Model2.TableRow;
using CFW.Sample.Model2.TableProperty;
using CFW.Sample.Model2.Entity;
using CFW.Sample.Model2.Property;

using CFW.Sample.Model;
namespace TableModelTest
{
    [TestFixture]
    public class TableValidatorTest
    {
        TestTable3TableRow table = new TestTable3TableRow();
        TestTable3TableProperty properties = new TestTable3TableProperty();

        TestTable3Entity entity = new TestTable3Entity();
        TestTable3Property entityProperty = new TestTable3Property();

        [NUnit.Framework.SetUp]
        public void Init()
        {
            properties = new TestTable3TableProperty();
            //test̂߂ɒlύX
            ((CFW.FieldProperties.IntFieldProperty)properties.Field1).MinValue = 1;
            ((CFW.FieldProperties.IntFieldProperty)properties.Field1).MaxValue = 10;
 
            ((CFW.FieldProperties.StringFieldProperty)properties.Field2).MaxLength = 10;
            ((CFW.FieldProperties.StringFieldProperty)properties.Field2).MinLength = 5;


            ((CFW.FieldProperties.ShortFieldProperty)properties.Field5).MinValue = 1;
            ((CFW.FieldProperties.ShortFieldProperty)properties.Field5).MaxValue = 10;

            ((CFW.FieldProperties.DateFieldProperty)properties.Field3).MinValue = new DateTime(2000, 1, 1);
            ((CFW.FieldProperties.DateFieldProperty)properties.Field3).MaxValue = new DateTime(2009, 12, 31);

            entityProperty = new TestTable3Property();
            //test̂߂ɒlύX
            ((CFW.FieldProperties.IntFieldProperty)entityProperty.Field1).MinValue = 1;
            ((CFW.FieldProperties.IntFieldProperty)entityProperty.Field1).MaxValue = 10;

            ((CFW.FieldProperties.StringFieldProperty)entityProperty.Field2).MaxLength = 10;
            ((CFW.FieldProperties.StringFieldProperty)entityProperty.Field2).MinLength = 5;


            ((CFW.FieldProperties.ShortFieldProperty)entityProperty.Field5).MinValue = 1;
            ((CFW.FieldProperties.ShortFieldProperty)entityProperty.Field5).MaxValue = 10;

            ((CFW.FieldProperties.DateFieldProperty)entityProperty.Field3).MinValue = new DateTime(2000, 1, 1);
            ((CFW.FieldProperties.DateFieldProperty)entityProperty.Field3).MaxValue = new DateTime(2009, 12, 31);
        }
        [NUnit.Framework.Test]
        public void ValidateTest()
        {
            table = new TestTable3TableRow();
            table.Field1 = 101;
            table.Field2 = "12345678901";
            table.Field3 = new DateTime(1970, 2, 3);
            table.Field4 = 123.45M;
            table.Field5 = 101;
            table.Field6Sub1 = 10100;
            table.Field6Sub2 = 101000;

            TestTable3TableValidator validator = new TestTable3TableValidator(table, properties);
            bool valid = validator.Validate();

            Assert.IsFalse(valid);
            Assert.AreEqual(4, validator.ErrorMessages.Count);
            Assert.AreEqual("[field1] ͈͂𒴂Ă܂B1  10", validator.ErrorMessages[0]);
            Assert.AreEqual("[field2] ͈͂𒴂Ă܂B5  10", validator.ErrorMessages[1]);
            Assert.AreEqual("[field3] ͈͂𒴂Ă܂B2000/01/01  2009/12/31", validator.ErrorMessages[2]);
            Assert.AreEqual("[field5] ͈͂𒴂Ă܂B1  10", validator.ErrorMessages[3]);

        }
        [NUnit.Framework.Test]
        public void ValidateTest2()
        {
            table = new CFW.Sample.Model2.TableRow.TestTable3TableRow();
            table.Field1 = 101;
            table.Field2 = "12345678901";
            table.Field3 = new DateTime(1970, 2, 3);
            table.Field4 = 123.45M;
            table.Field5 = 101;
            table.Field6Sub1 = 10100;
            table.Field6Sub2 = 101000;

            CFW.Model.Validator<CFW.Sample.Model2.TableRow.TestTable3TableRow, CFW.Sample.Model2.TableProperty.TestTable3TableProperty> validator =
                new CFW.Model.Validator<CFW.Sample.Model2.TableRow.TestTable3TableRow, CFW.Sample.Model2.TableProperty.TestTable3TableProperty>(table, properties);
            bool valid = validator.Validate();

            Assert.IsFalse(valid);
            Assert.AreEqual(4, validator.ErrorMessages.Count);
            Assert.AreEqual("[field1] ͈͂𒴂Ă܂B1  10", validator.ErrorMessages[0]);
            Assert.AreEqual("[field2] ͈͂𒴂Ă܂B5  10", validator.ErrorMessages[1]);
            Assert.AreEqual("[field3] ͈͂𒴂Ă܂B2000/01/01  2009/12/31", validator.ErrorMessages[2]);
            Assert.AreEqual("[field5] ͈͂𒴂Ă܂B1  10", validator.ErrorMessages[3]);

        }
        [NUnit.Framework.Test]
        public void ValidateTest3()
        {
            entity = new TestTable3Entity();
            entity.Field1 = 101;
            entity.Field2 = "12345678901";
            entity.Field3 = new DateTime(1970, 2, 3);
            entity.Field4 = 123.45M;
            entity.Field5 = 101;
            entity.Field6Sub1 = 10100;
            entity.Field6Sub2 = 101000;

            CFW.Model.Validator<TestTable3Entity, TestTable3Property> validator =
                new CFW.Model.Validator<TestTable3Entity, TestTable3Property>(entity, entityProperty);
            bool valid = validator.Validate();

            Assert.IsFalse(valid);
            Assert.AreEqual(4, validator.ErrorMessages.Count);
            Assert.AreEqual("[field1] ͈͂𒴂Ă܂B1  10", validator.ErrorMessages[0]);
            Assert.AreEqual("[field2] ͈͂𒴂Ă܂B5  10", validator.ErrorMessages[1]);
            Assert.AreEqual("[field3] ͈͂𒴂Ă܂B2000/01/01  2009/12/31", validator.ErrorMessages[2]);
            Assert.AreEqual("[field5] ͈͂𒴂Ă܂B1  10", validator.ErrorMessages[3]);

        }
        [NUnit.Framework.Test]
        public void ValidateTest4()
        {
            table = new TestTable3TableRow();
            table.Field1 = 1;
            table.Field2 = "12345";
            table.Field3 = new DateTime(2001, 2, 3,4,5,6);
            table.Field4 = 123.45M;
            table.Field5 = 10;
            table.Field6Sub1 = 10100;
            table.Field6Sub2 = 101000;

            TestTable3TableValidator validator = new TestTable3TableValidator(table, properties);
            bool valid = validator.Validate();

            Assert.IsTrue(valid);

        }
    }
}
