using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.FieldProperties;
using CFW.Windows;
using CFW.Windows.Forms;
using CFW.Windows.Forms.Adapters;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Validators;
namespace im6test.Forms
{

    public partial class GcDateTest : Form
    {
        GcDateAdapterElement element1;
        GcDateAdapterElement element2;
        GcDateAdapterElement element3;
        GcDateAdapterElement element4;
        GcDateAdapterElement element5;
        GcDateAdapterElement element6;

        FieldProperty property1;
        FieldProperty property2;
        FieldProperty property3;
        FieldProperty property4;
        FieldProperty property5;
        FieldProperty property6;
        

        public GcDateTest()
        {
            InitializeComponent();
            initializeProperties();
            initializeElements();
        }
        private void initializeProperties()
        {
			property1 = FieldProperty.NewInstance("datetime", "test", "field1","[field1]", 16, 23, 3, true, null,false);
            property2 = FieldProperty.NewInstance("datetime", "test", "field2", "[field2]", 16, 23, 3, true, null, false);
            property3 = FieldProperty.NewInstance("datetime", "test", "field3", "[field3]", 16, 23, 3, true, null, false);
            property4 = FieldProperty.NewInstance("datetime", "test", "field4", "[field4]", 16, 23, 3, true, null, false);
            property5 = FieldProperty.NewInstance("datetime", "test", "field5", "[field5]", 16, 23, 3, true, null, false);
            property6 = FieldProperty.NewInstance("datetime", "test", "field6", "[field6]", 16, 23, 3, true, null, false);
        }
        private void initializeElements()
        {
            element1 = new GcDateAdapterElement(gcDate1,
                new DateTimeFilter("yyyy/MM/dd"),
                FieldValidator.GetInstance(property1)
            );
            element2 = new GcDateAdapterElement(gcDate2,
                new DateTimeFilter("yy/MM/dd"),
                FieldValidator.GetInstance(property2)
            );
            element3 = new GcDateAdapterElement(gcDate3,
                new DateTimeFilter("MM/dd"),
                FieldValidator.GetInstance(property3)
            );
            element4 = new GcDateAdapterElement(gcDate4,
                new DateTimeFilter("HH:mm:ss"),
                FieldValidator.GetInstance(property4)
            );
            element5 = new GcDateAdapterElement(gcDate5,
                new DateTimeFilter("HH:mm"),
                FieldValidator.GetInstance(property5)
            );
            element6 = new GcDateAdapterElement(gcDate6,
                new DateTimeFilter("yyyy/MM/dd HH:mm:ss"),
                FieldValidator.GetInstance(property6)
            );

        }

        private void button1_Click(object sender, EventArgs e)
        {
            DateTime? newValue = CFW.Util.DateUtil.Parse(textBox1.Text);
            element1.SetValue(newValue);
            element2.SetValue(newValue);
            element3.SetValue(newValue);
            element4.SetValue(newValue);
            element5.SetValue(newValue);
            element6.SetValue(newValue);

            element1.Render();
            element2.Render();
            element3.Render();
            element4.Render();
            element5.Render();
            element6.Render();

        }

        private void button2_Click(object sender, EventArgs e)
        {
            element1.UpdateField();
            element2.UpdateField();
            element3.UpdateField();
            element4.UpdateField();
            element5.UpdateField();
            element6.UpdateField();

            if (element1.Validate()) resultText1.Text = CFW.Util.DateUtil.Format(element1.GetValue());
            else resultText1.Text = element1.ErrorMessage;

            if (element2.Validate()) resultText2.Text = CFW.Util.DateUtil.Format(element2.GetValue());
            else resultText2.Text = element2.ErrorMessage;

            if (element3.Validate()) resultText3.Text = CFW.Util.DateUtil.Format(element3.GetValue());
            else resultText3.Text = element3.ErrorMessage;
            
            if (element4.Validate()) resultText4.Text = CFW.Util.DateUtil.Format(element4.GetValue());
            else resultText4.Text = element4.ErrorMessage;
            
            if (element5.Validate()) resultText5.Text = CFW.Util.DateUtil.Format(element5.GetValue());
            else resultText5.Text = element5.ErrorMessage;
            
            if (element6.Validate()) resultText6.Text = CFW.Util.DateUtil.Format(element6.GetValue());
            else resultText6.Text = element6.ErrorMessage;
        }

    }
}