using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.FieldProperties;
using CFW.Windows;
using CFW.Windows.Forms;
using CFW.Windows.Forms.Adapters;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Validators;

namespace im6test.Forms
{
    public partial class GcDropDownTest : Form
    {
        FormAdapterElement element1;
        FormAdapterElement element2;
        FormAdapterElement element3;
        FormAdapterElement element4;

        FieldProperty property1;
        FieldProperty property2;
        FieldProperty property3;
        FieldProperty property4;

        public GcDropDownTest()
        {
            InitializeComponent();



            gcComboBox1.Items.Add("f1");
            gcComboBox1.Items.Add("f2");
            gcComboBox1.Items.Add("f3");
            gcComboBox1.Items.Add("f4");

            gcComboBox2.Items.Add("f1");
            gcComboBox2.Items[0].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f001"));
            gcComboBox2.Items.Add("f2");
            gcComboBox2.Items[1].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f002"));
            gcComboBox2.Items.Add("f3");
            gcComboBox2.Items[2].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f003"));
            gcComboBox2.Items.Add("f4");
            gcComboBox2.Items[3].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f004"));

            gcComboBox3.Items.Add("f1");
            gcComboBox3.Items[0].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f001"));
            gcComboBox3.Items.Add("f2");
            gcComboBox3.Items[1].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f002"));
            gcComboBox3.Items.Add("f3");
            gcComboBox3.Items[2].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f003"));
            gcComboBox3.Items.Add("f4");
            gcComboBox3.Items[3].SubItems.Add(new GrapeCity.Win.Editors.SubItem("f004"));




            gcComboBox4.AutoGenerateColumns = true;
            gcComboBox4.DataSource = (new TestDataSource()).GetSource();
            gcComboBox4.TextSubItemIndex = 1;

            
            initializeProperties();
            initializeElements();
        }
        private void initializeProperties()
        {
            property1 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field1]", 50, 50, 0, false, "", false);
            property2 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field2]", 10, 10, 0, false, "", false);
            property3 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field3]", 20, 20, 0, false, "", false);
            property4 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field4]", 30, 30, 0, false, "", false);
        }
        private void initializeElements()
        {
            element1 = new CFW.Windows.Forms.Adapters.GcDropDownListAdapterElement(
                this.gcComboBox1,
                0,
                0
            );
            element2 = new CFW.Windows.Forms.Adapters.GcDropDownListAdapterElement(
                this.gcComboBox2,
                0,
                1
            );
            element3 = new CFW.Windows.Forms.Adapters.GcDropDownListAdapterElement(
                this.gcComboBox3,
                1,
                0
            );
            element4 = new CFW.Windows.Forms.Adapters.GcDropDownListAdapterElement(
                this.gcComboBox4,
                1,
                0
            );

        }

        private void button1_Click(object sender, EventArgs e)
        {
            string newValue = CFW.Util.StringUtil.NormalizeString(textBox1.Text,CFW.Util.StringUtil.NormalizeMode.Default);
            element1.SetValue(newValue);
            element1.Render();

            element2.SetValue(newValue);
            element2.Render();

            element3.SetValue(newValue);
            element3.Render();

            element4.SetValue(newValue);
            element4.Render();

        }

        private void button2_Click(object sender, EventArgs e)
        {
            element1.UpdateField();
            element2.UpdateField();
            element3.UpdateField();
            element4.UpdateField();

            if (element1.Validate()) resultText1.Text = CFW.Util.StringUtil.StringValue(element1.GetValue());
            else resultText1.Text = element1.ErrorMessage;

            if (element2.Validate()) resultText2.Text = CFW.Util.StringUtil.StringValue(element2.GetValue());
            else resultText2.Text = element2.ErrorMessage;

            if (element3.Validate()) resultText3.Text = CFW.Util.StringUtil.StringValue(element3.GetValue());
            else resultText3.Text = element3.ErrorMessage;

            if (element4.Validate()) resultText4.Text = CFW.Util.StringUtil.StringValue(element4.GetValue());
            else resultText4.Text = element4.ErrorMessage;

        }

    }
}