using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.FieldProperties;
using CFW.Windows;
using CFW.Windows.Forms;
using CFW.Windows.Forms.Adapters;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Validators;

namespace im6test.Forms
{
    public partial class GcNumberTest : Form
    {
        FormAdapterElement element1;
        FormAdapterElement element2;
        FormAdapterElement element3;
        FormAdapterElement element4;

        FieldProperty property1;
        FieldProperty property2;
        FieldProperty property3;
        FieldProperty property4;


        public GcNumberTest()
        {
            InitializeComponent();
            initializeProperties();
            initializeElements();

        }
        private void initializeProperties()
        {
            property1= FieldProperty.NewInstance("int", "test_table3", "field1", "[field1]", 4, 6, 0, false, 0, false);
            property2= FieldProperty.NewInstance("int", "test_table3", "field2", "[field2]", 4, 2, 0, true, null, false);
            property3= FieldProperty.NewInstance("decimal", "test_table3", "field3", "[field3]", 20, 5, 2, false, 0, false);
            property4= FieldProperty.NewInstance("decimal", "test_table3", "field4", "[field4]", 20, 6, 0, true, null, false);
        }
        private void initializeElements()
        {
            element1 = new CFW.Windows.Forms.Adapters.GcNumberAdapterElement(
                this.gcNumber1,
                new CFW.Forms.Filters.NumberFilter<int>(property1),
                CFW.Validators.FieldValidator.GetInstance(property1)
            );
            element2 = new CFW.Windows.Forms.Adapters.GcNumberAdapterElement(
                this.gcNumber2,
                new CFW.Forms.Filters.NumberFilter<int?>(property2),
                CFW.Validators.FieldValidator.GetInstance(property2)
            );
            element3 = new CFW.Windows.Forms.Adapters.GcNumberAdapterElement(
                this.gcNumber3,
                new CFW.Forms.Filters.NumberFilter<decimal>(property3),
                CFW.Validators.FieldValidator.GetInstance(property3)
            );
            element4 = new CFW.Windows.Forms.Adapters.GcNumberAdapterElement(
                this.gcNumber4,
                new CFW.Forms.Filters.NumberFilter<decimal?>(property4),
                CFW.Validators.FieldValidator.GetInstance(property4)
            );
        }

        private void button1_Click(object sender, EventArgs e)
        {
            decimal? newValue = CFW.Util.NumberUtil.Value<decimal?>(textBox1.Text);
            element1.SetValue(newValue);
            element1.Render();

            element2.SetValue(newValue);
            element2.Render();

            element3.SetValue(newValue);
            element3.Render();

            element4.SetValue(newValue);
            element4.Render();
        }
        private void button2_Click(object sender, EventArgs e)
        {
            element1.UpdateField();
            element2.UpdateField();
            element3.UpdateField();
            element4.UpdateField();

            if (element1.Validate()) resultText1.Text = CFW.Util.StringUtil.StringValue(element1.GetValue());
            else resultText1.Text = element1.ErrorMessage;

            if (element2.Validate()) resultText2.Text = CFW.Util.StringUtil.StringValue(element2.GetValue());
            else resultText2.Text = element2.ErrorMessage;

            if (element3.Validate()) resultText3.Text = CFW.Util.StringUtil.StringValue(element3.GetValue());
            else resultText3.Text = element3.ErrorMessage;

            if (element4.Validate()) resultText4.Text = CFW.Util.StringUtil.StringValue(element4.GetValue());
            else resultText4.Text = element4.ErrorMessage;

        }

    }
}