using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.FieldProperties;
using CFW.Windows;
using CFW.Windows.Forms;
using CFW.Windows.Forms.Adapters;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Validators;
using CFW.Util;
namespace im6test.Forms
{
    public partial class GcTextTest : Form
    {
        FormAdapterElement element1;
        FormAdapterElement element2;
        FormAdapterElement element3;
        FormAdapterElement element4;

        FieldProperty property1;
        FieldProperty property2;
        FieldProperty property3;
        FieldProperty property4;

        public GcTextTest()
        {
            InitializeComponent();
            initializeProperties();
            initializeElements();
        }
        private void initializeProperties()
        {
            property1= FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field1]", 50, 50, 0, false, "", false);
            property2= FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field2]", 10, 10, 0, false, "", false);
            property3= FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field3]", 20, 20, 0, false, "", false);
            property4= FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field4]", 30, 30, 0, false, "", false);
        }
        private void initializeElements()
        {
            gcTextBox1.MaxLength = property1.Length;
            gcTextBox2.MaxLength = property2.Length;
            gcTextBox3.MaxLength = property3.Length;
            gcTextBox4.MaxLength = property4.Length;

            element1 = new CFW.Windows.Forms.Adapters.GcTextBoxAdapterElement(
                this.gcTextBox1,
                new CFW.Forms.Filters.StringFilter(property1, StringUtil.NormalizeMode.ToNarrow | StringUtil.NormalizeMode.ToAlpha | StringUtil.NormalizeMode.ToUpper | StringUtil.NormalizeMode.TrimAll),
                CFW.Validators.FieldValidator.GetInstance(property1)
            );
            element2 = new CFW.Windows.Forms.Adapters.GcTextBoxAdapterElement(
                this.gcTextBox2,
                new CFW.Forms.Filters.StringFilter(property2, StringUtil.NormalizeMode.ToNarrow | StringUtil.NormalizeMode.ToAlpha | StringUtil.NormalizeMode.ToLower | StringUtil.NormalizeMode.TrimAll),
                CFW.Validators.FieldValidator.GetInstance(property2)
            );
            element3 = new CFW.Windows.Forms.Adapters.GcTextBoxAdapterElement(
                this.gcTextBox3,
                new CFW.Forms.Filters.StringFilter(property3, StringUtil.NormalizeMode.ToNarrow | StringUtil.NormalizeMode.ToDigit | StringUtil.NormalizeMode.TrimAll),
                CFW.Validators.FieldValidator.GetInstance(property3)
            );
            element4 = new CFW.Windows.Forms.Adapters.GcTextBoxAdapterElement(
                this.gcTextBox4,
                new CFW.Forms.Filters.StringFilter(property4, StringUtil.NormalizeMode.ToNarrow | StringUtil.NormalizeMode.ToAlphaDigit | StringUtil.NormalizeMode.ToUpper | StringUtil.NormalizeMode.TrimAll),
                CFW.Validators.FieldValidator.GetInstance(property4)
            );
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string newValue = CFW.Util.StringUtil.StringValue(textBox1.Text);
            element1.SetValue(newValue);
            element1.Render();

            element2.SetValue(newValue);
            element2.Render();

            element3.SetValue(newValue);
            element3.Render();

            element4.SetValue(newValue);
            element4.Render();
        }
        private void button2_Click(object sender, EventArgs e)
        {
            element1.UpdateField();
            element2.UpdateField();
            element3.UpdateField();
            element4.UpdateField();

            if (element1.Validate()) resultText1.Text = CFW.Util.StringUtil.StringValue(element1.GetValue());
            else resultText1.Text = element1.ErrorMessage;

            if (element2.Validate()) resultText2.Text = CFW.Util.StringUtil.StringValue(element2.GetValue());
            else resultText2.Text = element2.ErrorMessage;

            if (element3.Validate()) resultText3.Text = CFW.Util.StringUtil.StringValue(element3.GetValue());
            else resultText3.Text = element3.ErrorMessage;

            if (element4.Validate()) resultText4.Text = CFW.Util.StringUtil.StringValue(element4.GetValue());
            else resultText4.Text = element4.ErrorMessage;

        }
    }
}