﻿using System;
using System.Web;
using System.Collections;
using System.Collections.Generic;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Configuration;
using System.Data;
using System.Data.Common;
using System.Text;
using System.Reflection;
using System.Xml;
using System.Xml.Serialization;
using System.IO;

using CFW;
using CFW.Serializer;
using CFW.Util;
using CFW.Database;
using CFW.Database.Config;
using CFW.Config;
using CFW.Log;

/// <summary>
/// DbWebService の概要の説明です
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]

public class DbWebService : System.Web.Services.WebService
{
    CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("cfw.debug", "DbWebService");
    CFW.Auth.User currentUser;

    const string SESSION_PRIVATE_KEY = "DbWebService.PrivateKey";
    const string SESSION_CONNECTION = "DbWebService.Connection";
    const string SESSION_CURRENT_USER = "DbWebService.Current";

    public DbWebService()
    {

        //デザインされたコンポーネントを使用する場合、次の行をコメントを解除してください 
        //InitializeComponent(); 
    }

    /// <summary>
    /// 接続を開く
    /// </summary>
    [WebMethod(EnableSession=true)]
    public virtual string Open(int isolation, bool beginTransaction,string userId)
    {
        logger.Debug(MethodBase.GetCurrentMethod().Name, "tran =" + beginTransaction.ToString());
        logger.Debug(MethodBase.GetCurrentMethod().Name, "userId =" + userId);
        currentUser = createServiceUser(userId);

        string key = NewPrivateKey();
        Session[SESSION_PRIVATE_KEY] = key;
        CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName(currentUser, "default");
        connection.Open((IsolationLevel)isolation,beginTransaction);
        
        Session[SESSION_CONNECTION] = connection;
        Session[SESSION_CURRENT_USER] = currentUser;


        return key;
    }
    CFW.Auth.User createServiceUser(string currentUser)
    {
        CFW.Auth.User u = new CFW.Auth.User();
        u.Id = currentUser;
        u.Name = "user via web service";
        return u;
    }
    CFW.Auth.User getCurrentUser()
    {
        return Session[SESSION_CURRENT_USER] as CFW.Auth.User;
    }
    /// <summary>
    /// 接続を閉じる
    /// </summary>
    [WebMethod(EnableSession = true)]
    public void Close(bool commitTransaction)
    {
        logger.Log(LogLevel.DEBUG,getCurrentUser(), MethodBase.GetCurrentMethod().Name, new ServiceMessage("commit=" + commitTransaction.ToString()));
        CFW.Database.Connection connection = this.GetConnection();
        GetConnection().Close(commitTransaction);
        Session.Clear();
        Session.Abandon();
    }
    bool ValidatePrivateKey(string privateKey)
    {
        string storedKey = (string)Session[SESSION_PRIVATE_KEY];
        if (privateKey == storedKey)
        {
            return true;
        }
        else
        {
            logger.Log(LogLevel.ERROR, getCurrentUser(), MethodBase.GetCurrentMethod().Name, new ServiceMessage( string.Format("invalid user agent") ));
            return false;
        }
    }
    CFW.Database.Connection GetConnection()
    {
        return (CFW.Database.Connection)Session[SESSION_CONNECTION];
    }
    /// <summary>
    /// クエリー実行
    /// </summary>
    /// <param name="command"></param>
    /// <param name="timeout"></param>
    [WebMethod(EnableSession = true)]
    public virtual DataSet ExecuteQuery(string privateKey, string serializedCommand, int timeout)
    {
        logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, new ServiceMessage("start"));
        if (!this.ValidatePrivateKey(privateKey)) return null;

        Command command = DeserializeCommand(serializedCommand);
        CFW.Database.Connection connection = this.GetConnection();
        try
        {
            DataSet result = connection.ExecuteQuery(command, timeout);

            return result;
        }
        catch (ConnectionException ex)
        {
            CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
            builder.WriteLog();
            throw CFW.Web.Util.SoapExceptionBuilder.Build(builder);
        }
        finally
        {
            logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, "end");
        }

    }

    /// <summary>
    /// スカラークエリー実行
    /// </summary>
    /// <param name="command"></param>
    /// <param name="timeout"></param>
    [WebMethod(EnableSession = true)]
    public virtual object ExecuteScalar(string privateKey, string serializedCommand, int timeout)
    {
        logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, new ServiceMessage("start"));
        if (!this.ValidatePrivateKey(privateKey)) return null;
        Command command = DeserializeCommand(serializedCommand);

        CFW.Database.Connection connection = this.GetConnection();
        try
        {
            return connection.ExecuteScalar(command,timeout);

        }
        catch (ConnectionException ex)
        {
            CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
            builder.WriteLog();
            throw CFW.Web.Util.SoapExceptionBuilder.Build(builder);
        }
        finally
        {
            logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, "end");
        }
    }

    /// <summary>
    /// クエリー実行
    /// </summary>
    /// <param name="command"></param>
    /// <param name="timeout"></param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public virtual int ExecuteUpdate(string privateKey, string serializedCommand, int timeout)
    {
        logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, new ServiceMessage("start"));

        if (!this.ValidatePrivateKey(privateKey)) return 0;
        Command command = DeserializeCommand(serializedCommand);

        CFW.Database.Connection connection = this.GetConnection();
        try
        {
            return connection.ExecuteUpdate(command,timeout);

        }
        catch (ConnectionException ex)
        {
            CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
            builder.WriteLog();
            throw CFW.Web.Util.SoapExceptionBuilder.Build(builder);
        }
        finally
        {
            logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, "end");
        }
    }
    /// <summary>
    /// クエリーを実行してシリアライズする
    /// </summary>
    /// <param name="command"></param>
    /// <param name="timeout"></param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public virtual string ExecuteQueryAsSerialized(string privateKey, string serializedCommand, int timeout)
    {
        logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, new ServiceMessage("start"));

        if (!this.ValidatePrivateKey(privateKey)) return null;
        Command command = DeserializeCommand(serializedCommand);

        CFW.Database.Connection connection = this.GetConnection();
        try
        {
            return connection.ExecuteQueryAsSerialized(command,timeout);

        }
        catch (ConnectionException ex)
        {
            CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
            builder.WriteLog();
            throw CFW.Web.Util.SoapExceptionBuilder.Build(builder);
        }
        finally
        {
            logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, "end");
        }
    }
    /// <summary>
    /// クエリーを実行してシリアライズする
    /// </summary>
    /// <param name="command"></param>
    /// <param name="timeout"></param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public virtual string ExecuteQueryBatchAsSerialized(string privateKey, string serializedCommand, int timeout)
    {
        logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, new ServiceMessage("start"));

        if (!this.ValidatePrivateKey(privateKey)) return null;
        Command[] commands = DeserializeCommandArray(serializedCommand);

        CFW.Database.Connection connection = this.GetConnection();
        try
        {
            DataSet result = connection.ExecuteQueryBatch(commands);
            DataSetJSON serializer = new DataSetJSON();
            StringWriter writer = new StringWriter();

            serializer.SerializeDataSet(writer,result);
            return writer.ToString();

        }
        catch (ConnectionException ex)
        {
            CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
            builder.WriteLog();
            throw CFW.Web.Util.SoapExceptionBuilder.Build(builder);
        }
        finally
        {
            logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, "end");
        }
    }
    /// <summary>
    /// クエリー一括実行
    /// </summary>
    /// <param name="commands"></param>
    /// <param name="timeout"></param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public virtual DataSet ExecuteQueryBatch(string privateKey, string serializedCommand, int timeout)
    {
        logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, new ServiceMessage("start"));

        if (!this.ValidatePrivateKey(privateKey)) return null;
        Command[] commands = DeserializeCommandArray(serializedCommand);
        CFW.Database.Connection connection = this.GetConnection();
        try
        {
            return connection.ExecuteQueryBatch(commands,timeout);

        }
        catch (ConnectionException ex)
        {
            CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
            builder.WriteLog();
            throw CFW.Web.Util.SoapExceptionBuilder.Build(builder);
        }
        finally
        {
            logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, "end");
        }

    }


    /// <summary>
    /// クエリー一括実行
    /// </summary>
    /// <param name="commands"></param>
    /// <param name="timeout"></param>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public virtual int ExecuteUpdateBatch(string privateKey, string serializedCommand, int timeout)
    {
        logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, new ServiceMessage("start"));

        if (!this.ValidatePrivateKey(privateKey)) return 0;
        Command[] commands = DeserializeCommandArray(serializedCommand);
        CFW.Database.Connection connection = this.GetConnection();
        try
        {
            return connection.ExecuteUpdateBatch(commands,timeout);

        }
        catch (ConnectionException ex)
        {
            CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
            builder.WriteLog();
            throw CFW.Web.Util.SoapExceptionBuilder.Build(builder);
        }
        finally
        {
            logger.Log(LogLevel.DEBUG, getCurrentUser(), MethodBase.GetCurrentMethod().Name, "end");
        }

    }

    string NewPrivateKey()
    {
        string key = CFW.Util.Util.MD5(System.Guid.NewGuid().ToString());
        return key;
    }
    [WebMethod]
    public System.Data.DbType GetDbType(DbType t)
    {
        return t;
    }
    [WebMethod]
    public System.Data.CommandType GetCommandType(CommandType  t)
    {
        return t;
    }
    /// <summary>
    /// 最新ID
    /// </summary>
    /// <returns></returns>
    [WebMethod(EnableSession = true)]
    public DateTime SystemDate(string privateKey)
    {
        return DateTime.Now;
    }
    /// <summary>
    /// トランザクション開始
    /// </summary>
    /// <param name="isolation">トランザクション分離レベル</param>
    [WebMethod(EnableSession = true)]
    public virtual void BeginTransaction(string privateKey,int isolation)
    {
        logger.Debug(MethodBase.GetCurrentMethod().Name, "");
        if (!this.ValidatePrivateKey(privateKey)) return;
        CFW.Database.Connection connection = this.GetConnection();

        try
        {
            connection.BeginTransaction((IsolationLevel)isolation);

        }
        catch (ConnectionException ex)
        {
            CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
            builder.WriteLog();
            throw CFW.Web.Util.SoapExceptionBuilder.Build(builder);
        }
        finally
        {
        }
    }
    /// <summary>
    /// トランザクション終了
    /// </summary>
    [WebMethod(EnableSession = true)]
    public virtual void CommitTransaction(string privateKey)
    {
        logger.Debug(MethodBase.GetCurrentMethod().Name, "");
        if (!this.ValidatePrivateKey(privateKey)) return;
        CFW.Database.Connection connection = this.GetConnection();

        try
        {
            connection.CommitTransaction();

        }
        catch (ConnectionException ex)
        {
            CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
            builder.WriteLog();
            throw CFW.Web.Util.SoapExceptionBuilder.Build(builder);
        }
        finally
        {
        }
    }
    /// <summary>
    /// トランザクション終了
    /// </summary>
    [WebMethod(EnableSession = true)]
    public virtual void RollbackTransaction(string privateKey)
    {
        logger.Debug(MethodBase.GetCurrentMethod().Name, "");
        if (!this.ValidatePrivateKey(privateKey)) return;
        CFW.Database.Connection connection = this.GetConnection();

        try
        {
            connection.RollbackTransaction();

        }
        catch (ConnectionException ex)
        {
            CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
            builder.WriteLog();
            throw CFW.Web.Util.SoapExceptionBuilder.Build(builder);
        }
        finally
        {
        }
    }

    Command DeserializeCommand(string s)
    {
        StringReader reader = new StringReader(s);
        XmlSerializer serializer = new XmlSerializer(typeof(Command));
        Command command = (Command) serializer.Deserialize(reader);
        return command;
    }
    Command[] DeserializeCommandArray(string s)
    {
        StringReader reader = new StringReader(s);
        XmlSerializer serializer = new XmlSerializer(typeof(Command[]));
        Command[] command = (Command[])serializer.Deserialize(reader);
        return command;
    }
    class ServiceMessage
    {
        public string message;
        public ServiceMessage(string message)
        {
            this.message = message;
        }
        public override string ToString()
        {
            string remoteAddress = HttpContext.Current.Request.UserHostAddress;
            return string.Format( "remote address={0}\t{1}" ,remoteAddress,message ) ;
        }
    }
}

