// VacationHome.cs
using System;
using System.ComponentModel;
using System.Drawing;
using System.Security.Permissions;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;
using System.Text;
using System.IO;

[assembly: WebResource("SampleControl.JScript1.js", "text/javascript", PerformSubstitution = true)]
namespace Samples.AspNet.CS.Controls
{
    [
    AspNetHostingPermission(SecurityAction.InheritanceDemand,
        Level = AspNetHostingPermissionLevel.Minimal),
    AspNetHostingPermission(SecurityAction.Demand,
        Level = AspNetHostingPermissionLevel.Minimal),
    Designer(typeof(YuiModuleDesigner)),
    DefaultProperty("Title"),
    ToolboxData(
        "<{0}:YuiModule runat=\"server\"> </{0}:YuiModule>"),
    ]
    public class YuiModule : CompositeControl
    {
        protected ITemplate headerTemplateValue;
        protected ITemplate bodyTemplateValue;
        protected ITemplate footerTemplateValue;
        protected YuiModuleTemplateOwner headerOwnerValue;
        protected YuiModuleTemplateOwner bodyOwnerValue;
        protected YuiModuleTemplateOwner footerOwnerValue;



        [
        Browsable(false),
        DesignerSerializationVisibility(
            DesignerSerializationVisibility.Hidden)
        ]
        public YuiModuleTemplateOwner HeaderOwner
        {
            get
            {
                return headerOwnerValue;
            }
        }
        [
        Browsable(false),
        DesignerSerializationVisibility(
            DesignerSerializationVisibility.Hidden)
        ]
        public YuiModuleTemplateOwner BodyOwner
        {
            get
            {
                return bodyOwnerValue;
            }
        }
        [
        Browsable(false),
        DesignerSerializationVisibility(
            DesignerSerializationVisibility.Hidden)
        ]
        public YuiModuleTemplateOwner FooterOwner
        {
            get
            {
                return footerOwnerValue;
            }
        }

        [
        Browsable(false),
        PersistenceMode(PersistenceMode.InnerProperty),
        DefaultValue(typeof(ITemplate), ""),
        Description("Control template"),
        TemplateContainer(typeof(YuiPanel))
        ]
        public virtual ITemplate HeaderTemplate
        {
            get
            {
                return headerTemplateValue;
            }
            set
            {
                headerTemplateValue = value;
            }
        }
        [
        Browsable(false),
        PersistenceMode(PersistenceMode.InnerProperty),
        DefaultValue(typeof(ITemplate), ""),
        Description("Control template"),
        TemplateContainer(typeof(YuiPanel))
        ]
        public virtual ITemplate BodyTemplate
        {
            get
            {
                return bodyTemplateValue;
            }
            set
            {
                bodyTemplateValue = value;
            }
        }
        [
        Browsable(false),
        PersistenceMode(PersistenceMode.InnerProperty),
        DefaultValue(typeof(ITemplate), ""),
        Description("Control template"),
        TemplateContainer(typeof(YuiPanel))
        ]
        public virtual ITemplate FooterTemplate
        {
            get
            {
                return footerTemplateValue;
            }
            set
            {
                footerTemplateValue = value;
            }
        }

        [
        Bindable(true),
        Category("Data"),
        DefaultValue(""),
        Description("Title"),
        Localizable(true)
        ]
        public virtual string Title
        {
            get
            {
                string s = (string)ViewState["Title"];
                return (s == null) ? String.Empty : s;
            }
            set
            {
                ViewState["Title"] = value;
            }
        }
        [
        Category("Display"),
        DefaultValue(true),
        Description("ModuleVisible")
        ]
        public virtual bool ModuleVisible
        {
            get
            {
                return (ViewState["ModuleVisible"] == null ? false : (bool)ViewState["ModuleVisible"]);
            }
            set
            {
                ViewState["ModuleVisible"] = value;
            }
        }
        public virtual string YuiClassName
        {
            get
            {
                return "YAHOO.widget.Module";
            }
        }
        protected override void CreateChildControls()
        {
            Controls.Clear();

            headerOwnerValue = new YuiModuleTemplateOwner();
            ITemplate temp = headerTemplateValue;
            if (temp == null)
            {
                temp = new YuiModuleDefaultTemplate();
            }
            temp.InstantiateIn(headerOwnerValue);
            headerOwnerValue.CssClass = "hd";
            this.Controls.Add(headerOwnerValue);

            bodyOwnerValue = new YuiModuleTemplateOwner();
            temp = bodyTemplateValue;
            if (temp == null)
            {
                temp = new YuiModuleDefaultTemplate();
            }

            temp.InstantiateIn(bodyOwnerValue);
            bodyOwnerValue.CssClass = "bd";
            this.Controls.Add(bodyOwnerValue);


            footerOwnerValue = new YuiModuleTemplateOwner();
            temp = footerTemplateValue;
            if (temp == null)
            {
                temp = new YuiModuleDefaultTemplate();
            }

            temp.InstantiateIn(footerOwnerValue);
            footerOwnerValue.CssClass = "ft";
            this.Controls.Add(footerOwnerValue);

        }

        public override void DataBind()
        {
            CreateChildControls();
            ChildControlsCreated = true;
            base.DataBind();
        }
        protected override HtmlTextWriterTag TagKey
        {
            get
            {
                return HtmlTextWriterTag.Div;
            }
        }
        protected override void OnPreRender(EventArgs e)
        {
            base.OnPreRender(e);
            string initstring = "";
            initstring = @"var {0} = new {1}(""{0}"",{2});{0}.render();";
            string config = this.BuildConfiguration();
            this.Page.ClientScript.RegisterStartupScript(this.GetType(), this.ClientID + "init", string.Format(initstring, this.ClientID,this.YuiClassName, config), true);
        }
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            ScriptManager sm = ScriptManager.GetCurrent(this.Page);
            sm.Scripts.Add(new ScriptReference("~/javascript/yui-2.6.0/utilities/utilities.js"));
            sm.Scripts.Add(new ScriptReference("~/javascript/yui-2.6.0/container/container.js"));
        }

        protected virtual string BuildConfiguration()
        {
            StringWriter writer = new StringWriter();
            BuildConfigurationElements(writer);

            return "{" +  writer.ToString() + "}";
        }
        protected virtual void BuildConfigurationElements(System.IO.StringWriter writer)
        {
            writer.Write("visible:" + (ModuleVisible ? "true" : "false"));
        }

    }
    [
    ToolboxItem(false)
    ]
    public class YuiModuleTemplateOwner : WebControl
    {
        protected override HtmlTextWriterTag TagKey
        {
            get
            {
                return HtmlTextWriterTag.Div;
            }
        }
    }

    #region DefaultTemplate
    sealed class YuiModuleDefaultTemplate : ITemplate
    {
        void ITemplate.InstantiateIn(Control owner)
        {
            Panel p = new Panel();
            LiteralControl literal = new LiteralControl("aaaa");
            p.Controls.Add(literal);
            owner.Controls.Add(p);


        }

    }
    #endregion


    public class YuiModuleDesigner : ControlDesigner
    {

        public override void Initialize(IComponent Component)
        {
            base.Initialize(Component);
            SetViewFlags(ViewFlags.TemplateEditing, true);
        }

        public override string GetDesignTimeHtml()
        {
            YuiModule control;
            StringWriter writer = new StringWriter();
            HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);

            control = (YuiModule)Component;
            control.RenderControl(htmlWriter);
            return writer.ToString();
        }

        public override TemplateGroupCollection TemplateGroups
        {
            get
            {
                TemplateGroupCollection collection = new TemplateGroupCollection();
                TemplateGroup group;
                TemplateDefinition template;
                YuiModule control;

                control = (YuiModule)Component;

                group = new TemplateGroup("Header");
                template = new TemplateDefinition(this, "HeaderTemplate", control, "HeaderTemplate", true);
                group.AddTemplateDefinition(template);
                collection.Add(group);

                group = new TemplateGroup("Body");
                template = new TemplateDefinition(this, "BodyTemplate", control, "BodyTemplate", true);
                group.AddTemplateDefinition(template);
                collection.Add(group);

                group = new TemplateGroup("Footer");
                template = new TemplateDefinition(this, "FooterTemplate", control, "FooterTemplate", true);
                group.AddTemplateDefinition(template);
                collection.Add(group);

                return collection;
            }
        }
    }

}