using System;
using System.ComponentModel;
using System.Drawing;
using System.Security.Permissions;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;
using System.Text;
using System.IO;

namespace Samples.AspNet.CS.Controls
{
    [
    AspNetHostingPermission(SecurityAction.InheritanceDemand,
        Level = AspNetHostingPermissionLevel.Minimal),
    AspNetHostingPermission(SecurityAction.Demand,
        Level = AspNetHostingPermissionLevel.Minimal),
    Designer(typeof(YuiModuleDesigner)),
    ToolboxData(
        "<{0}:YuiTab runat=\"server\"> </{0}:YuiTab>"),
    ]
    public class YuiTab : CompositeControl
    {
        protected ITemplate templateValue;
        protected YuiModuleTemplateOwner ownerValue;

        [
        Browsable(false),
        DesignerSerializationVisibility(
            DesignerSerializationVisibility.Hidden)
        ]
        public YuiModuleTemplateOwner Owner
        {
            get
            {
                return ownerValue;
            }
        }

        [
        Browsable(false),
        PersistenceMode(PersistenceMode.InnerProperty),
        DefaultValue(typeof(ITemplate), ""),
        Description("Control template"),
        TemplateContainer(typeof(VacationHome))
        ]
        public virtual ITemplate Template
        {
            get
            {
                return templateValue;
            }
            set
            {
                templateValue = value;
            }
        }
        [
        Browsable(true),
        DefaultValue(""),
        Description("Tab Title")
        ]
        public virtual string Title
        {
            get
            {
                string s = (string)ViewState["Title"];
                return (s == null) ? String.Empty : s;
            }
            set
            {
                ViewState["Title"] = value;
            }
        }
        [
        Browsable(true),
        DefaultValue(""),
        Description("Default Activate")
        ]
        public virtual bool Default
        {
            get
            {
                return (ViewState["Default"] == null ? false : (bool)ViewState["Default"]);
            }
            set
            {
                ViewState["Default"] = value;
            }
        }

        protected override void CreateChildControls()
        {
            Controls.Clear();
            ownerValue = new YuiModuleTemplateOwner();

            ITemplate temp = templateValue;
            if (temp == null)
            {
                temp = new DefaultTemplate();
            }

            temp.InstantiateIn(ownerValue);
            this.Controls.Add(ownerValue);
        }
        protected override HtmlTextWriterTag TagKey
        {
            get
            {
                return HtmlTextWriterTag.Div;
            }
        }

    }
    [
    ToolboxItem(false)
    ]
    public class YuiTabTemplateOwner : WebControl
    {
        protected override HtmlTextWriterTag TagKey
        {
            get
            {
                return HtmlTextWriterTag.Unknown;
            }
        }
    }

    #region DefaultTemplate
    sealed class YuiTabDefaultTemplate : ITemplate
    {
        void ITemplate.InstantiateIn(Control owner)
        {
        }

    }
    #endregion


    public class YuiTabDesigner : ControlDesigner
    {

        public override void Initialize(IComponent Component)
        {
            base.Initialize(Component);
            SetViewFlags(ViewFlags.TemplateEditing, true);
        }

        public override string GetDesignTimeHtml()
        {

            return "<div>yui tab</div>";
        }

        public override TemplateGroupCollection TemplateGroups
        {
            get
            {
                TemplateGroupCollection collection = new TemplateGroupCollection();
                TemplateGroup group;
                TemplateDefinition template;
                YuiTab control;

                control = (YuiTab)Component;

                group = new TemplateGroup("Template");
                template = new TemplateDefinition(this, "Template", control, "Template", true);
                group.AddTemplateDefinition(template);
                collection.Add(group);


                return collection;
            }
        }
    }

}
