<?php
Zend_Loader::loadClass("CFW_Acl_IRule");
Zend_Loader::loadClass("CFW_Acl_IResource");
Zend_Loader::loadClass("CFW_Acl_IRole");
Zend_Loader::loadClass("CFW_Acl_Rule");
Zend_Loader::loadClass("CFW_Acl_Resource");
Zend_Loader::loadClass("CFW_Acl_RuleEnumerator");
Zend_Loader::loadClass("CFW_Acl_Role");
Zend_Loader::loadClass("CFW_Acl_Privilege");
Zend_Loader::loadClass("CFW_Model_TreeNode");


class CFW_Acl_AccessControl{
    var $rules;
    var $resources;
    var $roles;

    var $resourceIndex;
    var $roleIndex;

    public function __construct(){
        $this->resources= new CFW_Model_TreeNode();
        $this->roles = new CFW_Model_TreeNode();
        $this->rules = array();
        $this->resourceIndex = array();
        $this->roleIndex= array();

    }
    public function addRole($roleName,$parentName = null){
        $parent = null;
        if($parentName == null){
            $parent = $this->roles;
        }
        else{
            $parent = $this->roles->find($this->roleIndex[$parentName]);
        }
        $role = new CFW_Acl_Role($roleName);
        $parent->appendChild($role);
        //インデックス構築
        $this->roleIndex[$roleName] = $role->path();
    }
    public function addResource($resourceName,$parentName = null){
        $parent = null;
        if($parentName == null){
            $parent = $this->resources;
        }
        else{
            $parent = $this->resources->find($this->resourceIndex[$parentName]);
        }
        $resource = new CFW_Acl_Resource($resourceName);
        $parent->appendChild($resource);
        //インデックス構築(指定された名前に対してパス情報の配列を保存する)
        $this->resourceIndex[$resourceName] = $resource->path();
    }
    public function addRule($resourceName,$roleName,$privilege = CFW_Acl_Privilege::ALL){
        $resource = $this->resources->find($this->resourceIndex[$resourceName]);
        $role = $this->roles->find($this->roleIndex[$roleName]);

        $rule = new CFW_Acl_Rule();
        $rule->setResourceName($resourceName);
        $rule->setRoleName($roleName);
        $rule->setPrivilege($privilege);

        $this->rules[] = $rule;
    }


	public function isAllowed($resourceName,$privilege,$roles){
        $normalizedRoles = $this->normalizeRoles($roles);

        $resource = $this->findResource($resourceName);
        //リソースを登録していなければ「アクセス制御されていない」= だれでも何でもできる。
        if ($resource == null) return true;
        $allow = false;
        $ruleExists = false;
        //指定されたロール全てについてルールを検索して許可されているルールを見つける
        foreach($normalizedRoles as $role){
            //指定リソースから根元方向にリソースツリーをたどり、許可されているルールを見つける
            $resourceNode = $resource;
            while ($resourceNode != null)
            {
                //指定ロールから根元方向にリソースツリーをたどり、許可されているルールを見つける
                $roleNode = $role;
                while ($roleNode != null)
                {
                    $resourceRules = new CFW_Acl_RuleEnumerator($this->rules, $resourceNode);
                    while ($resourceRules->next())
                    {
                        $rule = $resourceRules->current();
                        //直接指定されているルールがあれば採用
                        if ($rule->getRoleName() == $roleNode->getName())
                        {
                            $ruleExists = true;
                            $allow = $rule->isAllowed($privilege);
                            break;
                        }
                    }

                    if ($ruleExists) break;
                    $roleNode = $roleNode->getParent();
                }

                if ($ruleExists) break;
                $resourceNode = $resourceNode->getParent();
            }
            if ($ruleExists)
            {
                if ($allow) break; //どこかで許可されてたら他で拒否されていても許可
            }
        }
        return $allow;
	}
	public function isDenied($resourceName,$privilege,$roles){
        return !$this->isAllowed($resourceName,$privilege,$roles);
	}
	public function normalizeRoles($roles){
	    $normalized = array();
        foreach ($roles as $role)
        {
            //現在の$roleの子供がもとの$rolesにない時だけ正規のリストに追加する
            $hasChild = false;
            foreach($roles as $subRole){
                if($subRole->IsDescendantOf($role)){
                    $hasChild = true;
                    break;
                }
            }
            if(!$hasChild){
                $normalized[] = $role;
            }
        }
        return $normalized;
	}
	public function findResource($resourceName){
	   $key = $this->resourceIndex[$resourceName];
	   $resource = $this->resources->find($key);
	   return $resource;
	}
    public function findRole($roleName){
       $key = $this->roleIndex[$roleName];
       $role = $this->roles->find($key);
       return $role;
    }
}