<?php
/**
 * SQLデータベース用検索条件
 * @author okada
 *
 */
class CFW_Data_Criteria {
    const OPERATOR_NONE = "";
    const OPERATOR_EQ = "=";
    const OPERATOR_NE = "<>";
    const OPERATOR_LE = "<=";
    const OPERATOR_LT = "<";
    const OPERATOR_GE = ">=";
    const OPERATOR_GT = ">";
    const OPERATOR_IN = "IN";
    const OPERATOR_NOT_IN = "NOT IN";
    const OPERATOR_LIKE = "LIKE";
    const OPERATOR_BETWEEN = "BETWEEN";
    const OPERATOR_NOT = "NOT";
    const OPERATOR_AND = "AND";
    const OPERATOR_OR = "OR";

    const DIRECTION_ASC = "ASC";
    const DIRECTION_DESC = "DESC";

    const LIMIT_INFINITE  = -1;

    //recursive
	/**
	 * この条件に含まれるwhere条件オブジェクト
	 * @var array CFW_Data_Db_Criteria
	 */
	private $where;
	/**
	 * グルーピング
	 * @var array
	 */
	private $groupBy;
	/**
	 * ソート
	 * @var array
	 */
	private $orderBy;
	/**
	 * 集計抽出条件
	 * @var array
	 */
	private $having;

	/**
	 * この条件のwhere式
	 * @var string
	 */
	private $whereExpression;
	/**
	 * ソート式
	 * @var string
	 */
	private $orderByExpression;
	/**
	 * グルーピング式
	 * @var string
	 */
    private $groupByExpression;
    /**
     * 集計抽出条件式
     * @var string
     */
	private $havingExpression;
	/**
	 * 読み取りサイズ指定
	 * @var int
	 */
	private $limit;
	/**
	 * 読み取り開始位置(0から)指定
	 * @var int
	 */
	private $offset;

	/**
	 * $exprに対して設定されるパラメータ
	 * @var array
	 */
	var $_parameters;

	/**
	 * 構築
	 * @return unknown_type
	 */
	public function __construct(){
        $this->where = array();
        $this->where = array();
        $this->orderBy = array();
        $this->having = array();
        $this->groupBy = array();
        $this->_parameters = array();
        $this->whereExpression = "";
        $this->orderByExpression = "";
        $this->groupByExpression = "";
        $this->havingExpression = "";
        $this->limit = 0;
        $this->offset = 0;

	}

	/**
	 * @param CFW_Data_Criteria_Condition $condition
	 * @param string  $operator
	 * @return void
	 */
	public function addWhere($condition,$operator = self::OPERATOR_AND){
	    if(count($this->where) > 0){
	        $this->where[] = $operator;
	    }
        $this->where[] = $condition;
	}
    /**
     * 条件追加
     *
     * @param CFW_Data_Criteria_Condition $condition 検索条件
     * @return unknown_type
     */
	public function addWhereAnd($condition){
	    $this->addWhere($condition,self::OPERATOR_AND);
    }
    /**
     * 条件追加
     *
     * @param CFW_Data_Criteria_Condition $condition 検索条件
     * @return unknown_type
     */
    public function addWhereOr($condition){
        $this->addWhere($condition,self::OPERATOR_OR);
    }

    /**
     * 集計抽出条件追加
     * @param CFW_Data_Criteria_Condition $condition 検索条件
     * @param string $operator 追加するときの演算子
     * @return unknown_type
     */
    public function addHaving($condition,$operator = self::OPERATOR_AND){
        if(count($this->having) > 0){
            $this->having[] = $operator;
        }
        $this->having[] = $condition;
    }
    /**
     * 集計抽出条件追加
     * @param CFW_Data_Criteria_Condition $condition 検索条件
     * @return unknown_type
     */
    public function addHavingAnd($condition){
        $this->addHaving($condition,self::OPERATOR_AND);
    }
    /**
     * 集計抽出条件追加
     * @param CFW_Data_Criteria_Condition $condition 検索条件
     * @return unknown_type
     */
    public function addHavingOr($condition){
        $this->addHaving($condition,self::OPERATOR_OR);
    }

    /**
     * ソート列追加
     * @param $expr
     * @param $direction "ASC" or "DESC"
     * @return unknown_type
     */
    public function addOrderBy($expr,$direction = "ASC"){
        $this->orderBy[]= array( "expr" => $expr,"direction" => $direction);
    }
    /**
     * グルーピング列追加
     * @param $expr
     * @return unknown_type
     */
    public function addGroupBy($expr){
        $this->groupBy[]= $expr;

    }
    /**
     * 読み取りサイズ 設定
     * @param $limit
     * @return unknown_type
     */
    public function setLimit($limit){
        $this->limit = intval($limit);
    }
    /**
     * 読み取り開始位置設定
     * @param $offset
     * @return unknown_type
     */
    public function setOffset($offset){
        $this->offset = intval($offset);
    }

    /**
     * 条件を解析する
     * @return unknown_type
     */
	public function assemble(){
	    $this->assembleWhere();
        $this->assembleGroupBy();
        $this->assembleOrderBy();
        $this->assembleHaving();

	}
	/**
	 * where句の生成
	 * @return unknown_type
	 */
	function assembleWhere(){
        $this->whereExpression = "";
        $length = count($this->where);
        for($i = 0;$i < $length;$i++){
            $w = $this->where[$i];
            if(is_string($w)){
                $this->whereExpression .= " " . strval($w) . " ";
                continue;
            }

            $condition = $w;
            $this->whereExpression .= $condition->buildExpression();
            $this->_parameters = array_merge($this->_parameters,$condition->getParameters());
        }
	}
    /**
     * order by句の生成
     * @return unknown_type
     */
	function assembleOrderBy(){
        $str = "";
        foreach($this->orderBy as $orderBy){
            if($str !== "")$str .= ", ";
            $str .= $orderBy["expr"] . " " . $orderBy["direction"];
        }
        $this->orderByExpression = $str;
    }
    /**
     * group by句の生成
     * @return unknown_type
     */
    function assembleGroupBy(){
        $str = "";
        foreach($this->groupBy as $groupBy){
            if($str !== "")$str .= ", ";
            $str .= $groupBy;
        }
        $this->groupByExpression = $str;

    }
    /**
     * having句の生成
     * @return unknown_type
     */
    function assembleHaving(){
        $this->havingExpression = "";
        $length = count($this->having);
        for($i = 0;$i < $length;$i++){
            $w = $this->having[$i];
            if(is_string($w)){
                $this->havingExpression .= " " . strval($w) . " ";
                continue;
            }

            $condition = $w;
            $this->havingExpression .= $condition->buildExpression();
            $this->_parameters = array_merge($this->_parameters,$condition->getParameters());
        }
    }
    /**
	 * 条件解析後の式を取得
	 * @return unknown_type
	 */
	public function getWhereExpression(){
	    return $this->whereExpression;
	}
    /**
     * 条件解析後の式を取得
     * @return unknown_type
     */
	public function getOrderByExpression(){
        return $this->orderByExpression;

	}
    /**
     * 条件解析後の式を取得(逆ソート)
     * @return unknown_type
     */
	public function getOrderByReverseExpression(){
        $str = "";
        foreach($this->orderBy as $orderBy){
            if($str !== "")$str .= ", ";
            $dir = "DESC";
            if($orderBy["direction"] == "DESC"){
                $dir = "ASC";
            }
            $str .= $orderBy["expr"] . " " . $dir;
        }
        return $str;

    }
    /**
     * 条件解析後の式を取得
     * @return unknown_type
     */
    public function getGroupByExpression(){
        return $this->groupByExpression;

    }
    /**
     * 条件解析後の式を取得
     * @return unknown_type
     */
    public function getHavingExpression(){
        return $this->havingExpression;

    }
    /**
     * 条件解析後の式を取得
     * @return unknown_type
     */
    public function getLimit(){
        return $this->limit;

    }
    /**
     * 条件解析後の式を取得
     * @return unknown_type
     */
    public function getOffset(){
        return $this->offset;

    }
    /**
	 * この条件に設定されたパラメータを取得する
	 * @return unknown_type
	 */
	public function getParameters(){
        return $this->_parameters;

	}

}
?>