<?php
Zend_Loader::loadClass("CFW_IO_Reader");

/**
 * Fileからの読取装置
 * @author okada
 *
 */
class CFW_IO_FileReader extends CFW_IO_Reader{
    /**
     * ファイル名
     * @var unknown_type
     */
    var $filename;
    /**
     * ファイルハンドル
     * @var unknown_type
     */
    var $fp;

    /**
     * 入力バッファ
     * @var unknown_type
     */
    var $buffer;
    /**
     * 入力バッファ読み取り位置
     * @var unknown_type
     */
    var $bufferPointer;
    /**
     * 現在の入力バッファのサイズ
     * @var unknown_type
     */
    var $bufferLength;
    /**
     * 基本バッファサイズ デフォルト4096
     * @var unknown_type
     */
    var $bufferSize = 4096;
    /**
     * 構築
     * @param $filename ファイル名
     * @param $option オプション "buffer_size" バッファサイズ変更
     * @return unknown_type
     */
    public function __construct($filename,$option = array()){
        $this->filename = $filename;
        $this->fp = null;
        $this->buffer = "";
        $this->bufferPointer = 0;
        $this->bufferLength = 0;
        if(array_key_exists("buffer_size",$option)){
            $this->bufferSize = $option["buffer_size"];
        }
    }
    /**
     * 読み取り可能状態にする
     * @return unknown_type
     */
    public function open(){
        $this->fp = fopen($this->filename,"rb");
    }
    /**
     * ファイルを閉じる
     * @return unknown_type
     */
    public function close(){
        fclose($this->fp);
        $this->fp = null;
    }
    /**
     * (non-PHPdoc)
     * @see IO/CFW_IO_Reader#read()
     */
    public function read(){
        if($this->isEOF()){
            return CFW_IO_Reader::EOF;

        }

        if( ($this->bufferLength == 0) || ($this->bufferPointer >= $this->bufferLength )){
            $this->buffer = fread($this->fp,$this->bufferSize);
            $this->bufferLength = mb_strlen($this->buffer);
            $this->bufferPointer = 0;
        }

        $c = mb_substr($this->buffer,$this->bufferPointer,1);
        $this->bufferPointer++;
        return $c;
    }
    /**
     * (non-PHPdoc)
     * @see IO/CFW_IO_Reader#readLine()
     */
    public function readLine(){
        if($this->isEOF()){
            return CFW_IO_Reader::EOF;
        }

        if( ($this->bufferLength == 0) || ($this->bufferPointer >= $this->bufferLength )){
            $this->buffer = fread($this->fp,$this->bufferSize);

            $this->bufferLength = mb_strlen($this->buffer);
            $this->bufferPointer = 0;
        }
        else{
            if($this->bufferLength > $this->bufferSize){
                $this->buffer = mb_substr($this->buffer,$this->bufferPointer);
                $this->bufferLength = mb_strlen($this->buffer);
                $this->bufferPointer = 0;
            }

        }
        $buffer = "";
        $found = false;
        while(!$found){
            $pos = mb_strpos($this->buffer,"\r\n",$this->bufferPointer);
            if($pos !== false){
                $buffer .= mb_substr($this->buffer,$this->bufferPointer,$pos - $this->bufferPointer);
                $this->bufferPointer = $pos + 2;
                return $buffer;
            }
            $pos = mb_strpos($this->buffer,"\n",$this->bufferPointer);
            if($pos !== false){
                $buffer .= mb_substr($this->buffer,$this->bufferPointer,$pos - $this->bufferPointer);
                $this->bufferPointer = $pos + 1;
                return $buffer;
            }
            $pos = mb_strpos($this->buffer,"\r",$this->bufferPointer);
            if($pos !== false){
                $buffer .= mb_substr($this->buffer,$this->bufferPointer,$pos - $this->bufferPointer);
                $this->bufferPointer = $pos + 1;
                return $buffer;
            }

            //現在のバッファーからは見つからなかった
            if(feof($this->fp)) break;

            $buf = fread($this->fp,$this->bufferSize);
            $this->buffer .= $buf;
            $this->bufferLength = mb_strlen($this->buffer);

        }
        $buffer = mb_substr($this->buffer,$this->bufferPointer);
        $this->bufferPointer = $this->bufferLength;
        return $buffer;

    }
    /**
     * (non-PHPdoc)
     * @see IO/CFW_IO_Reader#isEOF()
     */
    public function isEOF(){
        if(feof($this->fp)){
            if($this->bufferLength > 0){
                if($this->bufferPointer >= $this->bufferLength ){
                    return true;
                }

            }
            else{
                return true;
            }
        }
        return false;

    }

}
?>