<?php
interface CFW_Model_ITreeNode{
    function getName();
    function setName($name);
    function getParent();
    function setParent($parent);
    function getChild($name);
    function getChildren();
    function setChildren($children);
    /**
	 * 子要素を追加する
	 * @param CFW_Model_ITreeNode $node
	 * @return unknown_type
	 */
	function appendChild(CFW_Model_ITreeNode $node);
	/**
	 * 子要素を削除する
	 * @param CFW_Model_ITreeNode $node
	 * @return unknown_type
	 */
	function removeChilde(CFW_Model_ITreeNode $node);
	/**
	 * このオブジェクトが指定ノードの先祖かどうか
	 * @param CFW_Model_ITreeNode $node
	 * @return unknown_type
	 */
	function isAncestorOf(CFW_Model_ITreeNode $node);
	/**
	 * このオブジェクトが指定ノードの子孫かどうか
	 * @param CFW_Model_ITreeNode $node
	 * @return unknown_type
	 */
	function isDescendantOf(CFW_Model_ITreeNode $node);
	/**
	 * パスを文字列として表現する
	 * @return String
	 */
	function pathString();
	/**
	 * パスを配列で返す
	 * @return CFW_Model_ITreeNode
	 */
	function path();
	/**
	 * 指定パスのノードを見つける
	 * @param array $path
	 * @return CFW_Model_ITreeNode
	 */
	function find($path = array());
}