<?php
/**
 * MS SqlServer用データベース接続
 * @author okada
 *
 */
class CFW_Database_Connection_Mssql extends CFW_Database_AbstractConnection{
	public function __construct($config){
	    parent::__construct($config);
	}
	/**
	 * (non-PHPdoc)
	 * @see Database/CFW_Database_AbstractConnection#_createDSN()
	 */
	function _createDSN(){
	   $dsn = $this->config->driver . ":";
	   $dsn .= "host=".$this->config->params->host . ";";	
       $dsn .= "dbname=".$this->config->params->dbname . ";";   
       $dsn .= "port=".$this->config->params->port. ";";
       return $dsn;
	}
	/**
	 * (non-PHPdoc)
	 * @see Database/CFW_Database_AbstractConnection#quote()
	 */
	public function quote($val,$type = CFW_Model_DataTypes::VARCHAR){
		$result = "";
	   	if($type == CFW_Model_DataTypes::INTEGER){
	   		$result = strval(intval($val));
	   	}
	   	else if($type == CFW_Model_DataTypes::FLOAT){
            $result = strval(floatval($val));
	   	}
        else{
            $result = "'" . str_replace("'","''", $val) . "'";
        }
        return $result;
        
	   	 
	}
	/**
	 * (non-PHPdoc)
	 * @see Database/CFW_Database_AbstractConnection#encode()
	 */
	public function encode($val){
        if(is_bool($val)) return $val;
        if(is_double($val)) return $val;
        if(is_float($val)) return $val;
        if(is_int($val)) return $val;
        if(is_long($val)) return $val;
        if(is_null($val)) return $val;
        if(is_numeric($val)) return $val;
		
        $encoded = mb_convert_encoding($val,$this->serverCharset,$this->clientCharset);
        return $encoded;
		
	}
	/**
	 * (non-PHPdoc)
	 * @see Database/CFW_Database_AbstractConnection#decode()
	 */
	public function decode($val){
		if(is_bool($val)) return $val;
        if(is_double($val)) return $val;
        if(is_float($val)) return $val;
        if(is_int($val)) return $val;
        if(is_long($val)) return $val;
        if(is_null($val)) return $val;
        if(is_numeric($val)) return $val;
        
		$decoded = mb_convert_encoding($val,$this->clientCharset,$this->serverCharset);
		return $decoded;
	}

	/**
	 * (non-PHPdoc)
	 * @see Database/CFW_Database_AbstractConnection#encodeVariables()
	 */
    public function encodeVariables(&$variables){
        return mb_convert_variables($this->serverCharset,$this->clientCharset,$variables);
    }
    /**
     * (non-PHPdoc)
     * @see Database/CFW_Database_AbstractConnection#decodeVariables()
     */
    public function decodeVariables(&$variables){
        return mb_convert_variables($this->clientCharset,$this->serverCharset,$variables);
    }
    
}
?>