<?php
/**
 * 二次元データの行
 * @author okada
 *
 */
class CFW_Model_DataRow{
    var $table;
    /**
     * 行の内部データ
     * @var unknown_type
     */
	var $_row;
	/**
	 * 状態
	 * @var unknown_type
	 */
	var $_state;
	/**
	 * 新規
	 * @var integer
	 */
	const STATE_NEW = 0;
    /**
     * 未更新
     * @var integer
     */
	const STATE_UNCHANGED = 1;
    /**
     * 変更状態
     * @var integer
     */
	const STATE_MODIFIED = 1;
    /**
     * 削除
     * @var integer
     */
	const STATE_DELETED = 99;
	
	/**
	 * 構築
	 * @return unknown_type
	 */
	public function __construct(){
	   $this->_row = array();
	   $this->_state = self::STATE_NEW;
	   	
	}
	public function setData($data){
	    $this->_row = $data;
	}
	/**
	 * 列データ取得
	 * @param $name
	 * @return unknown_type
	 */
	public function __get($name){
		return $this->_row[$name];
	}
	/**
	 * 列データ設定
	 * @param $name
	 * @param $value
	 * @return unknown_type
	 */
    public function __set($name,$value){
        $this->_row[$name] = $value;
       $this->_state = self::STATE_MODIFIED;
    }
    /**
     * 削除
     * @return unknown_type
     */
    public function delete(){
        $this->_state = self::STATE_DELETED;	
    }
    /*
     * 行状態取得
     */
    public function rowState(){
    	if($this->_state == self::STATE_DELETED){
    		return $this->_state;
    	}
        if($this->_state == self::STATE_NEW){
            return $this->_state;
        }
        
    	if($this->isNew()){
            $this->_state = self::STATE_NEW;
            return $this->_state;
    	}
    	
        return $this->_state;
    	
    }
    /**
     * 新規か否か
     * @return unknown_type
     */
    public function isNew(){
    	$pkeys = $this->table->_primaryKeys;
    	$flag = false;
    	foreach($pkeys as $pkey){
    	    if(array_key_exists($pkey,$this->_row)){
    		if(empty($this->_row[$pkey])){
    			$flag = true;
    			break;
    		}
    	    }
    	    else{
                $flag = true;
    	        
    	    }
    	}
    	return $flag;
    	
    }
}
?>