<?php
Zend_Loader::loadClass("CFW_Model_ITreeNode");
Zend_Loader::loadClass("CFW_Acl_IResource");

class CFW_Acl_Resource implements CFW_Acl_IResource{
    var $treeNode;
    public function __construct($name){
        $this->treeNode = new CFW_Model_TreeNode($name);

    }
    public function getName(){
        return $this->treeNode->getName();
    }
    public function setName($name){
        return $this->treeNode->setParent($name);
    }
    public function getParent(){
        return $this->treeNode->getParent();
    }
    public function setParent($parent){
        return $this->treeNode->setParent($parent);
    }
    public function getChildren(){
        return $this->treeNode->getChildren();
    }
    public function getChild($name){
        return $this->treeNode->getChild($name);
    }
    public function setChildren($children){
        return $this->treeNode->setChildren($children);
    }

    /**
     * 子要素を追加する
     * @param CFW_Model_ITreeNode $node
     * @return unknown_type
     */
    public function appendChild(CFW_Model_ITreeNode $node){$this->treeNode->appendChild($node);}
    /**
     * 子要素を削除する
     * @param CFW_Model_ITreeNode $node
     * @return unknown_type
     */
    public function removeChilde(CFW_Model_ITreeNode $node){ $this->treeNode->removeChild($node); }
    /**
     * このオブジェクトが指定ノードの先祖かどうか
     * @param CFW_Model_ITreeNode $node
     * @return unknown_type
     */
    function isAncestorOf(CFW_Model_ITreeNode $node){ return $this->treeNode->isAncestorOf($node); }
    /**
     * このオブジェクトが指定ノードの子孫かどうか
     * @param CFW_Model_ITreeNode $node
     * @return unknown_type
     */
    function isDescendantOf(CFW_Model_ITreeNode $node){ return $this->treeNode->isDescendantOf($node); }
    /**
     * パスを文字列として表現する
     * @return String
     */
    public function pathString(){ return $this->treeNode->pathString(); }
    /**
     * パスを配列で返す
     * @return CFW_Model_ITreeNode
     */
    public function path(){ return $this->treeNode->path(); }
    /**
     * 指定パスのノードを見つける
     * @param array $path
     * @return CFW_Model_ITreeNode
     */
    function find($path = array()){ return $this->treeNode->find($path); }

}