<?php
Zend_Loader::loadClass("CFW_Acl_IRule");
Zend_Loader::loadClass("CFW_Acl_IResource");
Zend_Loader::loadClass("CFW_Acl_IRole");
Zend_Loader::loadClass("CFW_Acl_Privilege");
class CFW_Acl_Rule implements CFW_Acl_IRule{
	var $id;
	var $resourceName;
	var $roleName;
	var $description;
	var $privilege;

    /**
     * リソース名取得
     * @return unknown_type
     */
    function getResourceName(){ return $this->resourceName; }
    /**
     * リソース名設定
     * @param unknown_type $value
     * @return unknown_type
     */
    function setResourceName($value){ $this->resourceName = $value;}
    /**
     * ロール名取得
     * @return unknown_type
     */
    function getRoleName(){ return $this->roleName;}
    /**
     * ロール名設定
     * @param unknown_type $value
     * @return unknown_type
     */
    function setRoleName($value){ $this->roleName = $value;}

    /**
     * 権限取得
     * @return unknown_type
     */
    function getPrivilege(){ return $this->privilege;}
    /**
    * 権限設定
     * @param unknown_type $value
     * @return unknown_type
     */
    function setPrivilege($value){$this->privilege = (CFW_Acl_Privilege::ALL & $value); /*余計なものをフィルタする*/ }

	/* (non-PHPdoc)
	 * @see CFW/Acl/CFW_Acl_IRule#isAllowed($privilege)
	 */
	public function isAllowed($privilege)
	{
		return ($this->privilege & $privilege) == $privilege;
	}

	/* (non-PHPdoc)
	 * @see CFW/Acl/CFW_Acl_IRule#isDenied($privilege)
	 */
	public function isDenied($privilege)
	{
		return ($this->privilege & $privilege) != $privilege;
	}

	/* (non-PHPdoc)
	 * @see CFW/Acl/CFW_Acl_IRule#allow($privilege)
	 */
	public function allow( $privilege)
	{
            $this->privilege |= $privilege;
	}

	/* (non-PHPdoc)
	 * @see CFW/Acl/CFW_Acl_IRule#deny($privilege)
	 */
	public function deny( $privilege)
	{
            $this->privilege &= (CFW_Acl_Privilege::ALL ^ privilege);
	}


}