<?php
Zend_Loader::loadClass("CFW_Data_Parameter");
Zend_Loader::loadClass("CFW_Data_Criteria");
Zend_Loader::loadClass("CFW_Model_Entity");
Zend_Loader::loadClass("CFW_Data_Connection");
Zend_Loader::loadClass("CFW_Data_Criteria_ColumnValueCondition");


class CFW_Data_DataSource{
	/**
	 * @var CFW_Data_Connection
	 */
	var $connection;
	var $entityProperty = null;
    var $tableName = "";

    var $selectQuery;
    var $insertQuery;
    var $updateQuery;
    var $deleteQuery;

    var $selectFields = array();
    var $updateFields = array();

    static $createdAtField = "created_at";
    static $modifiedAtField = "modified_at";

	public function __construct($connection,$property = null){
		$this->connection= $config;
		$this->entityProperty = $property;

	}
	public function setProperty($property){
		$this->entityProperty = $property;
	}
	public function setConnection($connection){
		$this->connection = $connection;
	}
    public function save($data,$fields = array()){
        $this->setupProperty($fields);
        $this->connection->beginTransaction();
        $entities = array();
        if(is_array($data)){
            $entities = $data;
        }
        else{
            $entities[] = $data;
        }
        $primaryKeys = $this->entityProperty->getPrimaryKeys();
        $criteria = $this->createPrimaryKeyCriteria($primaryKeys,null);
        $criteria->assemble();
        //各アイテムで違うのはパラメータの値だけなのでこれでいいはず
        $this->buildInsertQuery($this->updateFields);
        $this->buildUpdateQuery($criteria,$this->updateFields);
        $this->buildDeleteQuery($criteria);

        //削除、更新、挿入をアイテム毎に実行
        $result = 0;
        foreach($entities as  $entity){
            $parameters = array();
            if($entity->isDeleted){
                $criteria = $this->createPrimaryKeyCriteria($primaryKeys,$entity);
                $criteria->assemble();
                $result += $this->executeDelete($criteria);
            }
            else{
                if($entity->isModified){
                    if($entity->isNew){
                        $result += $this->executeInsert($entity);
                    }
                    else{
                        $criteria = $this->createPrimaryKeyCriteria($primaryKeys,$entity);
                        $criteria->assemble();
                        $result += $this->executeUpdate($entity,$criteria);
                    }
                }
            }

        }
        $this->connection->commitTransaction();
        return $result;


    }
    function createPrimaryKeyCriteria($primaryKeys,$entity){
        $criteria = new CFW_Data_Criteria();
        foreach($primaryKeys as $primaryKey ){
            $value = null;
            if($entity != null){
                $n = CFW_Util_String::lowerCamel($primaryKey->fieldName);
                if(isset($entity->$n)) $value = $entity->$n;

            }
            $criteria->addWhere(new CFW_Data_Criteria_ColumnValueCondition($primaryKey->fieldName,$value,CFW_Data_Criteria::OPERATOR_EQ));

        }
        return $criteria;
    }
    /**
     * @param  $entity
     * @return unknown_type
     */
    private function executeInsert($entity){
        $parameters= array();

        foreach($this->updateFields as $field){
            //TODO:作成日、更新日、作成者、更新者
            $parameter = null;
            $value = null;
            if(($field->fieldName == self::$createdAtField) || ($field->fieldName == self::$modifiedAtField)){
            	$value = $this->connection->systemDate();
                $n = CFW_Util_String::lowerCamel($field->fieldName);
            	$entity->$n = $value;
            }
            else{
                $n = CFW_Util_String::lowerCamel($field->fieldName);
                if(isset($entity->$n)) $value = $entity->$n;
            }
            $parameter = new CFW_Data_Parameter(
                ":" + $field->alias(),
                $value
            );
            $parameters[] = $parameter;

        }

        $command = $this->connection->createCommand($this->insertQuery,$parameters);
        $result = $command->executeUpdate();
        //IDがあったら最新の値をセット
        if($this->entityProperty->_identity != ""){
            $id = $this->connection->lastIdentity($this->entityProperty->getName());
            $n = $this->entityProperty->_identity;
            $entity->$n = intval( $id );
        }
        $entity->isNew =false;
        $entity->isModified = false;
        return $result;
    }
    private function executeUpdate($entity,CFW_Data_Criteria $criteria){
        $parameters= array();

        foreach($this->updateFields as $alias => $fieldName){
            //TODO:作成日、更新日、作成者、更新者
            $parameter = null;
            //作成日は更新させない
            if($fieldName == self::$createdAtField) continue;
            if($fieldName == self::$modifiedAtField){
                $parameter = new CFW_Data_Parameter(
                    ":" + $alias,
                    $this->connection->systemDate()
                );
            }
            else{
                $value = null;
                $n = CFW_Util_String::lowerCamel($fieldName);
                if(isset($entity->$n)) $value = $entity->$n;
                $parameter = new CFW_Data_Parameter(
                    ":" + $alias,
                    $value
                );
            }
            $parameters[] = $parameter;

        }
        $parameters = array_merge($parameters,$criteria->getParameters());
        $command = $this->connection->createCommand($this->updateQuery,$parameters);
        $result = $command->executeUpdate();
        $entity->isNew =false;
        $entity->isModified = false;
        return $result;

    }
    private function executeDelete($criteria){
        $fields = $this->entityProperty->getFields();
        $parameters= $criteria->getParameters();
        $command = $this->connection->createCommand($this->deleteQuery,$parameters);
        return $command->executeUpdate();
    }
    public function insert($data,$fields = array()){
        $this->setupProperty($fields);
        $entities = array();
        if(is_array($data)){
            $entities = $data;
        }
        else{
            $entities[] = $data;
        }
        $this->buildInsertQuery($this->updateFields);
        $result = 0;
        foreach($entities as $entity){
            $result += $this->executeInsert($entity);
        }
        return $result;
    }
    public function update($data,$criteria = null,$fields = array()){
        if($criteria == null) $criteria = new CFW_Data_Criteria();
        $this->setupProperty($fields);
        $fields = $this->entityProperty->getFields();
        $entities = array();
        if(is_array($data)){
            $entities = $data;
        }
        else{
            $entities[] = $data;
        }
        $criteria->assemble();
        $this->buildUpdateQuery($criteria,$this->updateFields);

        $result = 0;
        foreach($entities as $entity){
            $result += $this->executeUpdate($entity,$criteria);
        }
        return $result;
    }
    public function delete($criteria){
        $this->setupProperty();
        if($criteria == null) $criteria = new CFW_Data_Criteria();
        $criteria->assemble();
        $this->buildDeleteQuery($criteria);
        $this->executeDelete($criteria);
    }
    public function find($criteria = null,$fields = array()){
        $this->setupProperty($fields);
        if($criteria == null) $criteria = new CFW_Data_Criteria();
        $criteria->assemble();
        if(count($fields) == 0) {
            $fields = $this->getSelectFields();
        }
        $this->buildSelectQuery($criteria,$fields);
        $command = $this->connection->createCommand($this->selectQuery,$criteria->getParameters());
        return $command->executeQueryAsObject($this->entityProperty->entityClass,$this->entityProperty->getName());

    }
    public function findByPk($entity){
        $this->setupProperty($fields);
        $criteria = $this->createPrimaryKeyCriteria($this->entityProperty->getPrimaryKeys(),$entity);
        $criteria->assemble();
        if(count($fields) == 0) {
            $fields = $this->getSelectFields();
        }
        $this->buildSelectQuery($criteria,$fields);
        $command = $this->connection->createCommand($this->selectQuery,$criteria->getParameters());
        return $command->executeQueryAsObject($this->entityProperty->entityClass,$this->entityProperty->getName());

    }
    public function setupProperty($fields = array()){
        if($this->entityProperty == null){
            $this->entityProperty = $this->connection->describe($this->tableName);
        }
        $this->updateFields = array();
        if(count( $fields ) > 0){
            //fieldを指定されたときは指定されたfieldだけdoUpdateする
            $this->entityProperty->setDoUpdate(false);
            foreach($fields as $field){
                $p = $this->entityProperty->$field;
                if($p != null){
                	if($p->isIdentity)continue;
                    $p->doUpdate = true;
                    $this->updateFields[$p->fieldName] = $p;
                }
            }
        }
        else{
          	$this->updateFields = $this->entityProperty->getUpdateFields();
        }
    }
    function getSelectFields(){
        $fields= array();
        foreach($this->entityProperty->getFields() as $f){
            if($f->doUpdate){
                $fields[$f->alias()] =  $f->fullName();
            }
        }
        return $fields;
    }
    /**
     * @param CFW_Data_Criteria $c
     * @return unknown_type
     */
    public function buildSelectQuery(CFW_Data_Criteria $c,$fields){
            $query = "SELECT";
            $columns = "";
            $where =  "";
            $orderBy =  "";
            $groupBy =  "";
            $having =  "";
            $limits =  "";

            //columns 構築
            foreach($fields as $key => $field){
                if($columns != "") $columns .= ",";
                $columns .= $field . " AS " . $key;

            }
            if($c != null){
                //where句構築
                $where = $c->getWhereExpression();
                //orderBy構築
                $orderBy = $c->getOrderByExpression();
                //group by 構築
                $groupBy = $c->getGroupByExpression();
                //having構築
                $having = $c->getHavingExpression();
                //limit,offset
                if($c->getLimit() > 0){
                    $limits .= "LIMIT " . $c->getLimit();
                }
                if($c->getOffset() > 0){
                    $limits .= " OFFSET " . $c->getOffset();
                }
            }
            if($columns == ""){
                $query .= " *";
            }
            else{
                $query .= " " . $columns;
            }
            //TODO:複数テーブル対応
            $query .= " FROM " . $this->entityProperty->getName();
            if($where != ""){
                $query .= " WHERE " . $where;
            }
            if($groupBy != ""){
                $query .= " GROUP BY " . $groupBy;
            }
            if($having != ""){
                $query .= " HAVING " . $having;
            }
            if($orderBy != ""){
                $query .= " ORDER BY " . $orderBy;
            }

            $this->selectQuery = $query;

    }
    public function buildUpdateQuery($criteria,$fields){
        $query = "UPDATE";
        $columns = "";
        $where =  "";

        //columns 構築
        foreach($fields as $field){
            //作成日は何があっても更新させない
            if($field->fieldName== self::$createdAtField) continue;
            if($columns != "") $columns .= ",";
            $columns .= $field->fieldName . " = ?";
        }

        if($criteria != null){
            //where句構築
            $where = $criteria->getWhereExpression();
        }
        $query .= " " . $this->entityProperty->getName();
        $query .= " SET " . $columns;

        if($where != ""){
            $query .= " WHERE " . $where;
        }
        $this->updateQuery = $query;
    }
    public function buildInsertQuery($fields){
        $query = "INSERT INTO";
        $columns = "";
        $values = "";

        //columns 構築
        foreach($fields as $field){
            if($columns != ""){
                $columns .= ",";
                $values .= ",";
            }
            $columns .= $field->fieldName ;
            $values .= " ? ";
        }
        $query .= " " . $this->entityProperty->getName();
        $query .= " (" . $columns . ")" ;
        $query .= "  VALUES(" . $values . ")";

        $this->insertQuery = $query;

    }
    public function buildDeleteQuery($criteria){
        $query = "DELETE";
        $columns = "";
        $where =  "";

        if($criteria != null){
            //where句構築
            $where = $criteria->getWhereExpression();
        }
        $query .= " " . $this->entityProperty->getName();

        if($where != ""){
            $query .= " WHERE " . $where;
        }
        $this->deleteQuery = $query;

    }
}