<?php
/**
 * LDAP Criteria 解析
 * 
 * BNF
 * <logical_expression> ::= <expression>
 * <expression> ::= <term> [ "|" <term>]
 * <term> ::= <factor> [ "&" <factor> ] 
 * <factor> ::= ( <logical_expression> ) | <relative_expression>
 * <relative_operator> ::= = | ~= | >= | <=
 * <logical_operator> ::= "|" | "&" 
 * 
 *
 */

include("../../core.php");

class Element{
    var $modifier;
    
}
class OperatorElement extends Element{
    const OP_AND = "&";
    const OP_OR = "|";
    const OP_NOT = "!";
    const OP_EQ = "=";
    const OP_EQR = "~=";
    const OP_GE = ">=";
    const OP_LE = "<=";
    
    var $op;
    
    public function __construct($op){
        $this->op = $op;
    }
    
}
class ExpressionElement extends Element{
    var $expr;
    
    public function __construct($expr){
        $this->expr = $expr;
    }
}
class ComplexElement extends Element{
    var $expr;
    public function __construct(){
        $this->expr = array();
    }
}

class Expression{
    var $terms;
    var $modifier;
    
    public function __construct(){
        $this->terms= array();
    }
    public function parse(ArrayIterator &$iterator){
        $element = $iterator->current();

        $term = new Term();
        $this->terms[] = $term->parse($iterator);                
    
        while(true){
            if(!$iterator->valid()) break;
            
            $element = $iterator->current();
            if($element instanceof OperatorElement){
                if($element->op !== OperatorElement::OP_OR){
                    break;
                }
                
                $iterator->next();
                if(!$iterator->valid()) break;
            }
            $element = $iterator->current();
            $term = new Term();
            $this->terms[] = $term->parse($iterator);                

        }
        
        return $this;
        
    }
    public function dump(){
        if(count($this->terms) == 1){
            $term = $this->terms[0];
            if($this->modifier != ""){
                return "(". $this->modifier . "(".  $term->dump() . "))";
                
            }
            else{
                return  $term->dump() ;
            }
            
        }
        else if(count($this->terms) > 1){
            $s = "|";
            foreach($this->terms as $term){
                $s .=  $term->dump() ;
            }
            if($this->modifier != ""){
                return "(". $this->modifier . "(" . $s ."))";
                
            }
            else{
                return "(" . $s .")";
            }
            
        }
        
    }
}
class Term{
    var $facts;
    var $modifier;
    
    public function __construct(){
        $this->facts = array();
    }
    public function parse(ArrayIterator &$iterator){
        $fact = new Factor();
        $this->facts[] = $fact->parse($iterator); //最初のterm
        while (true) {
            if(!$iterator->valid()) break;
            
            $element = $iterator->current();
            if($element instanceof OperatorElement){
                if($element->op !== OperatorElement::OP_AND){
                    break;
                }
                
                $iterator->next();
                if(!$iterator->valid()) break;
            }
            
            
            $fact = new Factor();
            $this->facts[] = $fact->parse($iterator);
            
        }
        return $this;
        
    }
    public function dump(){
        if(count($this->facts) == 1){
            if($this->modifier != ""){
                return "(". $this->modifier . "(". $this->facts[0]->dump() . "))";
                
            }
            else{
                return $this->facts[0]->dump();
            }
            
        }
        else if(count($this->facts) > 1){
            $s = "&";
            foreach($this->facts as $fact){
                $s .=  $fact->dump() ;
            }
            if($this->modifier != ""){
                return "(". $this->modifier . "(" .$s . "))";
                
            }
            else{
                return "(" .$s . ")";
            }
            
        }
    }
}
class Factor{
    var $expr;
    
    public function parse(ArrayIterator &$iterator){
        $element = $iterator->current();
        if ($element instanceof ComplexElement) {
            
            $expr = new Expression();
            $it = new ArrayIterator(new ArrayObject($element->expr));
            $this->expr = $expr->parse($it);
            $this->expr->modifier = $element->modifier;
            $iterator->next();
            return $this;
        }
        else{
            $result = new RelativeCondition();
            $this->expr = $result->parse($iterator);
            $this->expr->modifier = $element->modifier;
            $iterator->next();
            return $this;
        }
    }
    public function dump(){
        
        
        return $this->expr->dump() ;
    }
}
class RelativeCondition{
    /**
     * 関係式
     * 
     * a=b,a=*,a<=d etc...
     * @var unknown_type
     */
    var $expr;
    var $modifier; 
    public function parse(ArrayIterator &$iterator){
        $element = $iterator->current();
        $this->expr = $element->expr;
        $this->modifire = $element->modifier;
        return $this;
    }
    public function dump(){
        if($this->modifier != ""){
        return "(" . $this->modifier . "("  . $this->expr .  "))" ;
            
        }
        else{
            return "(" . $this->expr . ")" ;
            
        }
        
    }
}

$elements = array();

$complex = new ComplexElement();
$complex->expr[] = new ExpressionElement( "a=a001" );

$complex->expr[] = new OperatorElement(OperatorElement::OP_OR);
$complex->expr[] = new ExpressionElement( "b=b001" );

$elements[] = $complex;



$complex = new ComplexElement();
$complex->expr[] = new ExpressionElement( "e=e001" );

$complex->expr[] = new OperatorElement(OperatorElement::OP_OR);
$complex->expr[] = new ExpressionElement( "f=f001" );
$complex->modifier = "!";

$elements[] = new OperatorElement(OperatorElement::OP_AND);
$elements[] = $complex;




// (|(a=b)(&(c=d)(e=f))(g=h))
$arr= new ArrayObject($elements);
$iterator = $arr->getIterator();


$filter = new Expression();
$result = $filter->parse($iterator);

echo $result->dump();

?>