<?php
/**
 * tokenizer実験(2)
 * @author okada
 *
 */
class Tokenizer{
    const EOF = false;
    /**
     * 読み取り装置
     * @var unknown_type
     */
    var $reader;
    /**
     * 最後に読み込んだ文字
     * @var unknown_type
     */
    var $c;
    var $token;
    
    var $ignore =  array(" ","\t", "\r\n");
    var $delimiter = array(" ","\t", "\r\n");
    var $operator = array("(",")","+","*","-","/");
    var $quotes = array("\"","'");

    
    
    public function __construct($reader,$option = array()){
        $this->reader = $reader;
        $this->c = null;
        
        if(array_key_exists("ignore", $option)){
            $this->ignore = $option["ignore"];        
        }
        
        if(array_key_exists("delimiter", $option)){
            $this->delimiter = $option["delimiter"];        
        }
        if(array_key_exists("operator", $option)){
            $this->operator = $option["operator"];        
        }
        if(array_key_exists("quote", $option)){
            $this->quotes = $option["quote"];        
        }
        
    }
    public function hasMoreTokens(){
        if($this->c === null){
            return !$this->reader->isEOF();
        }
        
        return ($this->c !== self::EOF);
    }
    public function nextToken(){
        if($this->c === self::EOF){
            return self::EOF;
        }

        if($this->c === null){
            $this->c = $this->reader->read();
            if($this->c === self::EOF){
                return self::EOF;
            }
        }
        
        /* white space読み飛ばし */
        if($this->isIgnoreChar($this->c)){
            while(!$this->c === self::EOF){
                if(!$this->isIgnoreChar($this->c)){
                    break;
                }
                $this->c = $this->reader->read();
            }
            
        }
        
        $inquote = "";
        $this->token = "";
        while($this->c){
            //引用符
            if($this->isQuote($this->c )){
                if($inquote == ""){
                    $inquote= $this->c;
                    $this->token .= $this->c;
                    $this->c = $this->reader->read();
                    continue;
                }
                    
                if($this->c == $inquote){
                    //現在の文字が引用開始文字と同じところまで、引用符つき文字列
                    $this->token .= $this->c;
                    $inquote = "";
                    $this->c = $this->reader->read();
                    break;
                }
                $this->token .= $this->c;
                $this->c = $this->reader->read();
                
                //引用符付き文字列開始
                continue;
            }
            // 引用符の内側なら全部入れる
            if($inquote != ""){
                if($this->c == "\\"){
                    $c2 = $this->reader->read();
                    $this->token .= $this->c;
                    $this->token .= $c2;
                }
                else{
                    $this->token .= $this->c;
                }
                $this->c = $this->reader->read();
                continue;
            }
            
            
            if($this->isOperator($this->c)){
                if($this->token == ""){
                    $this->token = $this->c;
                    $this->c = $this->reader->read();
                    break;
                }
                break;
            }    
            if($this->c == "\\"){
                $c2 = $this->reader->read();
                $this->token .= $this->c;
                $this->token .= $c2;
                $this->c = $this->reader->read();
                continue;
            }
            if($this->isDelimiter($this->c)){
                $this->c = $this->reader->read();
                break;
            }

            $this->token .= $this->c;
            $this->c = $this->reader->read();
            
        }   
        return $this->token;
        
        
    }
    function isIgnoreChar($c){
       if(in_array($c,$this->ignore)){
            return true;
        }   
        return false;
    }
    function isDelimiter($c){
       if(in_array($c,$this->delimiter)){
            return true;
        }   
        return false;
    }
    function isOperator($c){
        if(in_array($c,$this->operator)){
            return true;
        }   
        return false;
    }
    function isQuote($c){
        if(in_array($c,$this->quotes)){
            return true;
        }   
        return false;
    }
    
}

class StringReader{
    const EOF = false;
    var $str;
    var $len;
    var $ptr;
    
    var $pushBacked;
    
    public function __construct($s){
        $this->str = $s;
        $this->len = mb_strlen($s);
        $this->ptr = 0;
        $this->pushBacked = array();
        
    }
    public function read(){
        if($this->ptr >= $this->len  ){
            return self::EOF;
        }
        
        if(count($this->pushBacked) > 0){
            $c = array_pop($this->pushBacked);
        }
        else{
            $c = mb_substr($this->str,$this->ptr,1);
        }
        $this->ptr++;
        return $c;
    }
    public function readLine(){
        if($this->ptr >= $this->len  ){
            return self::EOF;
        }
        $buffer = "";
        
        $pos = strpos($this->str,"\r\n",$this->ptr);
        if($pos !== false){
            $buffer = mb_substr($this->str,$this->ptr,$pos - $this->ptr + 1);
            $this->ptr = $pos + 2;
            return $buffer;
        }
        $pos = strpos($this->str,"\n",$this->ptr);
        if($pos !== false){
            $buffer = mb_substr($this->str,$this->ptr,$pos - $this->ptr + 1);
            $this->ptr = $pos + 1;
            return $buffer;
        }
        $pos = strpos($this->str,"\r",$this->ptr);
        if($pos !== false){
            $buffer = mb_substr($this->str,$this->ptr,$pos - $this->ptr + 1);
            $this->ptr = $pos + 1;
            return $buffer;
        }
        $buffer = mb_substr($this->str,$this->ptr);
        return $buffer;
        
    }
    public function pushBack($c){
        array_push( $this->pushBacked , $c );
        $this->ptr--;
        
    }
    public function isEOF(){
        if($this->ptr >= $this->len  ){
            return true;
        }
        return false;
        
    }
    
}


$s = "";
$tokenizer = null;
if(isset($_POST["text"])){
    $s =$_POST["text"]; 
    $tokenizer = new Tokenizer( new StringReader( $s ));
    
}
else{
    
}



?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"> 
<title>tokenizer</title>
</head>
<body>
<div>
<form action="" method="post" >
<input type="text" name="text" id="text" value="<?php echo htmlspecialchars($s) ?>" size="100" /><br />
<input type="submit" name="submit" id="submit" value="send" />
</form>
<div id="result">
<?php if($tokenizer):?>
<?php while($tokenizer->hasMoreTokens()):?>
r=<?php echo htmlspecialchars($tokenizer->nextToken()) ?><br />
<?php endwhile;?>
<?php endif;?>
</div>
</div>
<script type="text/javascript">
//<![CDATA[
//]]>
</script>
</body>
</html>