<?php
include_once("../startup.php");
require_once 'PHPUnit/Framework.php';
require_once("CFW/Util/String.php");
require_once "Date.php";
require_once "Date/Calc.php";
require_once "Date/Span.php";
require_once "Date/TimeZone.php";
class StringUtilTest extends PHPUnit_Framework_TestCase
{
    public function testrepeat()
    {
    	$result = CFW_Util_String::repeat("a", 10);
    	$this->assertEquals("aaaaaaaaaa",$result);
    }
    public function testrepeat2(){
    	$result = CFW_Util_String::repeat("123", 10);
    	$this->assertEquals("123123123123123123123123123123", $result);
    }
    
    public function testNormalizeNumeric(){
    	$source = "1234567890abcdefghijklmn";
    	$result = CFW_Util_String::NormalizeNumeric($source);
    	
    	$this->assertEquals("1234567890", $result);
    	
    	$source = "1234567890.9876543210";
    	$result = CFW_Util_String::NormalizeNumeric($source);
    	
    	$this->assertEquals("1234567890.9876543210", $result);
    	
    	$source = "abcd1234567890.9876543210";
    	$result = CFW_Util_String::NormalizeNumeric($source);
    	
    	$this->assertEquals("1234567890.9876543210", $result);
    }
    public function testNormalizeAlpha(){
    	$source = " abcde	あいうえお　.234.abcde";
    	$result = CFW_Util_String::NormalizeAlpha($source);
    	
    	$this->assertEquals("abcdeabcde", $result);
    	
    	$source = " abcde	アイウエオｱｲｳｴｵ　.234ABCDE";
    	$result = CFW_Util_String::NormalizeAlpha($source);
    	
    	$this->assertEquals("abcdeABCDE", $result);
    	
    	$source = "!#$%&'.@`:abc<ABC>/\\-~";
    	$result = CFW_Util_String::NormalizeAlpha($source);
    	
    	$this->assertEquals("abcABC", $result);
    }
    public function testNormalizeAlphaNumeric(){
    	$source = "1234567890abcdefghijklmn";
    	$result = CFW_Util_String::NormalizeAlphaNumeric($source);
    	
    	$this->assertEquals("1234567890abcdefghijklmn", $result);
    	
    	$source = "1234567890.あいうえお9876543210";
    	$result = CFW_Util_String::NormalizeAlphaNumeric($source);
    	
    	$this->assertEquals("1234567890.9876543210", $result);
    	
    	$source = "abcd1";
    	$result = CFW_Util_String::NormalizeAlphaNumeric($source);
    	
    	$this->assertEquals("abcd1", $result);
    }
    public function testNormalizeDigit() {
    	$source = "1234567890abcdeABCDEあいうえおアイウエオｱｲｳｴｵ";
    	$result = CFW_Util_String::NormalizeDigit($source);
    	
    	$this->assertEquals("1234567890", $result);
    	
    	$source = "1234567890ａｂｃｄｅＡＢＣＤＥ１２３４５!#$%&'()=~||\\<>";
    	$result = CFW_Util_String::NormalizeDigit($source);
    	
    	$this->assertEquals("1234567890", $result);
    }
    
    public function testdeleteAllWhiteSpace(){
    	$source = " abcde　	";
    	$result = CFW_Util_String::deleteAllWhiteSpace($source);
    	
    	$this->assertEquals("abcde", $result);
    	
    	$source = " a bcde　	";
    	$result = CFW_Util_String::deleteAllWhiteSpace($source);
    	
    	$this->assertEquals("abcde", $result);
    	
    	$source = " a	b　cd e　	";
    	$result = CFW_Util_String::deleteAllWhiteSpace($source);
    	
    	$this->assertEquals("abcde", $result);
    }
    public function testTabToWhiteSpace() {
    	$source = "	abc	d	";
    	$result = CFW_Util_String::TabToWhiteSpace($source);
    	
    	$this->assertEquals(" abc d ", $result);;
    }
    
    public function testright() {
    	$source = "abcde";
    	$result = CFW_Util_String::right($source, 3);
    	
    	$this->assertEquals("cde", $result);
    	
    	$source = "あいうえお";
    	$result = CFW_Util_String::right($source, 3);
    	
    	$this->assertEquals("うえお", $result);
    	
    	$source = "abcde";
    	$result = CFW_Util_String::right($source, 6);
    	
    	$this->assertEquals("abcde", $result);
    }
    
    public function testtrimLeft() {
    	$source = " 	　abcde 	　";
    	$result = CFW_Util_String::trimLeft($source);
    	
    	$this->assertEquals("abcde 	　", $result);
    	
    	$source = " 	　あいうえお 	　";
    	$result = CFW_Util_String::trimLeft($source);
    	
    	$this->assertEquals("あいうえお 	　", $result);
    }
    public function testtrimRight() {
    	$source = " 	　abcde 	　";
    	$result = CFW_Util_String::trimRight($source);
    	
    	$this->assertEquals(" 	　abcde", $result);
    	
    	$source = " 	　あいうえお 	　";
    	$result = CFW_Util_String::trimRight($source);
    	
    	$this->assertEquals(" 	　あいうえお", $result);
    }
    public function testtrim() {
    	$source = " 	　abcde　	 ";
    	$result = CFW_Util_String::trim($source);
    	
    	$this->assertEquals("abcde", $result);
    	
    	$source = " 	　あいうえお　	　	";
    	$result = CFW_Util_String::trim($source);
    	
    	$this->assertEquals("あいうえお", $result);
    }
    
    public function testtoWide() {
    	$source = "ｱｲｳｴｵ()<>+-";
    	$result = CFW_Util_String::toWide($source);
    	
    	$this->assertEquals("アイウエオ（）＜＞＋－", $result);
    	
    	$source = "abcdeABCDE?!";
    	$result = CFW_Util_String::toWide($source);
    	
    	$this->assertEquals("ａｂｃｄｅＡＢＣＤＥ？！", $result);
    	
    	$source = "\\1,000";
    	$result = CFW_Util_String::toWide($source);
    	
    	$this->assertEquals("￥１，０００", $result);
    }
    public function testtoNarrow() {
    	$source = "アイウエオ＠＜＞＋－";
    	$result = CFW_Util_String::toNarrow($source);
    	
    	$this->assertEquals("ｱｲｳｴｵ@<>+-", $result);
    	
    	$source = "ａｂｃｄｅＡＢＣＤＥ？！";
    	$result = CFW_Util_String::toNarrow($source);
    	
    	$this->assertEquals("abcdeABCDE?!", $result);
    	
    	$source = "￥１，０００";
    	$result = CFW_Util_String::toNarrow($source);
    	
    	$this->assertEquals("\\1,000", $result);;
    }
    
    public function testNormalizeString() {
    	$source = " 	　abcd　	 ";
    	$result = CFW_Util_String::NormalizeString($source, CFW_Util_String::TrimAll);
    	
    	$this->assertEquals("abcd", $result);
    	
    	$source = " a b  c   d        ";
    	$result = CFW_Util_String::NormalizeString($source, CFW_Util_String::DeleteSpace);
    	
    	$this->assertEquals("abcd", $result);
    	
    	$source = " a	b  c   　d        ";
    	$result = CFW_Util_String::NormalizeString($source, CFW_Util_String::DeleteSpace);
    	
    	$this->assertEquals("a	bc　d", $result);
    	
    	$source = "　abc 　d　";
    	$result = CFW_Util_String::NormalizeString($source, CFW_Util_String::DeleteWideSpace);
    	
    	$this->assertEquals("abc d", $result);
    	
    	$source = "	a	b	c d	";
    	$result = CFW_Util_String::NormalizeString($source, CFW_Util_String::DeleteTab);
    	
    	$this->assertEquals("abc d", $result);
    	
    	$source = "ABCD";
    	$result = CFW_Util_String::NormalizeString($source, CFW_Util_String::ToLower);
    	
    	$this->assertEquals("abcd", $result);
    	
    	$source = "abcd";
    	$result = CFW_Util_String::NormalizeString($source, CFW_Util_String::ToUpper);
    	
    	$this->assertEquals("ABCD", $result);
    }
    
    public function testtoString() {
    	$source = 1234567890;
    	$result = CFW_Util_String::toString($source);
    	
    	$this->assertEquals("1234567890", $result);
    	
    	$source = new Date("20091126123456");
    	$result = CFW_Util_String::toString($source);
    	
    	$this->assertEquals("2009/11/26 12:34:56", $result);
    }
}

