<?php
/**
 * 認証機能の基本
 * @author okada
 * @package CFW_Auth
 */
class CFW_Auth_Provider{


	/**
	 * 認証情報保持
	 * @var CFW_Auth_Storage
	 */
	var $storage;
	/**
	 * 設定
	 * @var Zend_Config
	 */
	var $config;
	/**
	 * ハッシュ関数
	 * @var CFW_Auth_Hash
	 */
	var $hash;

	/**
	 * 認証処理
	 * @param unknown_type $userId
	 * @param unknown_type $password
	 * @return boolean
	 */
	public function authenticate($userId,$password){
		if($this->verify($userId,$password)){
			$identity = $this->loadIdentity($userId,$password);
			$this->storage->saveIdentity($identity);
			return true;
		}
		return false;

	}
	/**
	 * identity読み込み
	 * @param unknown_type $id
	 * @param unknown_type $password
	 * @return unknown_type
	 */
	public function loadIdentity($userId,$password){

	}
	/**
	 * IDとパスワードの検証
	 * @param unknown_type $id
	 * @param unknown_type $password
	 * @return unknown_type
	 */
	function verify($userId,$password){

	}
	/**
	 * @return unknown_type
	 */
	public function isAuthenticated(){
	   return $this->storage->isAuthenticated();
	}
	/**
	 * identityを取得
	 * @return unknown_type
	 */
	public function getIdentity(){
		return $this->storage->getIdentity();
	}
	/**
	 * ログアウト
	 * @return unknown_type
	*/
	public function logout(){
		$this->storage->removeIdentity();
	}
}