<?php
/**
 * データソース
 *
 * データ取得、保存のためのプロキシ
 * @author okada
 * @package CFW_Models
 */
abstract class CFW_Models_DataSource{
    /**
     * 接続
     * @return unknown_type
     */
    public abstract function connect();
    /**
     * 接続解除
     * @return unknown_type
     */
    public abstract function disconnect();
    /**
     * データ追加
     * @param CFW_Data_Model $model
     * @param array $fields
     * @param array $values
     * @return unknown_type
     */
	public abstract function insert(&$model,$values);
	/**
	 * データ更新
	 * @param CFW_Data_Model $model
	 * @param array $fields
	 * @param array $values
     * @param CFW_Data_Criteria $criteria
	 * @return unknown_type
	 */
	public abstract function update(&$model,$values,$criteria = null);
	/**
	 * データ削除
	 * @param CFW_Data_Model $model
	 * @param CFW_Data_Criteria $criteria
	 * @return unknown_type
	 */
	public abstract function delete(&$model,$criteria = null);
	/**
	 * 指定条件に該当するデータ読み取り
	 * @param $model
	 * @param $criteria
	 * @param $fields
	 * @param $order
	 * @param $limit
	 * @param $offset
	 * @return CFW_Data_Entity
	 */
	public abstract function read(&$model,$criteria = null);
	/**
	 * 指定条件に該当するデータの件数取得
	 * @param $model
	 * @param $criteria
	 * @return unknown_type
	 */
	public abstract function count(&$model,$criteria = null);
	/**
	 * エンティティの型情報取得
	 * @param $model
	 * @return unknown_type
	 */
	public abstract function describe(&$model);
	/**
	 * 実データソース取得
	 *
	 * datasource.class_nameに合致するデータソースをロードする。
	 * @param $config
	 * @return unknown_type
	 */
	public static function getDataSource($config){
	    $classname = $config->class_name;
	    return new $classname($config);
	}
}