<?php
Zend_Loader::loadClass("CFW_FieldProperties_Abstract");
Zend_Loader::loadClass("CFW_Models_EntityProperty");

/**
* table acl_resourcesに対応するフィールドプロパティ
*/
class CFW_Acl_Db_Models_Base_AclResourcesTableProperty extends  CFW_Models_EntityProperty
{
    /* var CFW_FieldProperties_Abstract [id] */
    public $id;
    /* var CFW_FieldProperties_Abstract [parent_id] */
    public $parentId;
    /* var CFW_FieldProperties_Abstract [name] */
    public $name;
    /* var CFW_FieldProperties_Abstract [left_side] */
    public $leftSide;
    /* var CFW_FieldProperties_Abstract [right_side] */
    public $rightSide;
    /* var CFW_FieldProperties_Abstract [description] */
    public $description;
    

    /**
    * default construct
    */
    public function __construct()
    {
        $this->entityName = "acl_resources";
        $this->id =  CFW_FieldProperties_Abstract::newInstance("int", "acl_resources", "id","[id]", 4, 10, 0, false, 0,true);
        $this->parentId =  CFW_FieldProperties_Abstract::newInstance("int", "acl_resources", "parent_id","[parent_id]", 4, 10, 0, true, 0,false);
        $this->name =  CFW_FieldProperties_Abstract::newInstance("varchar", "acl_resources", "name","[name]", 255, 0, 0, false, "",false);
        $this->leftSide =  CFW_FieldProperties_Abstract::newInstance("int", "acl_resources", "left_side","[left_side]", 4, 10, 0, false, 0,false);
        $this->rightSide =  CFW_FieldProperties_Abstract::newInstance("int", "acl_resources", "right_side","[right_side]", 4, 10, 0, false, 0,false);
        $this->description =  CFW_FieldProperties_Abstract::newInstance("varchar", "acl_resources", "description","[description]", 255, 0, 0, true, "",false);
        

        $this->entityClass = "CFW_Acl_Db_Models_Base_AclResourcesTableRow";
         
    }

    /**
    * 全てのフィールドを列挙
    * 
    * @returns 
    */
    public function getFields()
    {
        $fields = array();
        $fields[] = $this->id;
        $fields[] = $this->parentId;
        $fields[] = $this->name;
        $fields[] = $this->leftSide;
        $fields[] = $this->rightSide;
        $fields[] = $this->description;
        
        return $fields;
    }
    /**
    * 全ての主キーを列挙
    * 
    * @returns 
    */
    public function getPrimaryKeys()
    {
        $fields = array();
        $fields[] = $this->id;
        
        return $fields;
    }
    public function getUpdateFields(){
        $fields = array();
        if($this->id->doUpdate && !$this->id->isIdentity)$fields[] = $this->id;
        if($this->parentId->doUpdate && !$this->parentId->isIdentity)$fields[] = $this->parentId;
        if($this->name->doUpdate && !$this->name->isIdentity)$fields[] = $this->name;
        if($this->leftSide->doUpdate && !$this->leftSide->isIdentity)$fields[] = $this->leftSide;
        if($this->rightSide->doUpdate && !$this->rightSide->isIdentity)$fields[] = $this->rightSide;
        if($this->description->doUpdate && !$this->description->isIdentity)$fields[] = $this->description;
        
        return $fields;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setDoUpdate($doUpdate)
     */
    public function setDoUpdate($doUpdate = true){
        $this->id->doUpdate = $doUpdate;
        $this->parentId->doUpdate = $doUpdate;
        $this->name->doUpdate = $doUpdate;
        $this->leftSide->doUpdate = $doUpdate;
        $this->rightSide->doUpdate = $doUpdate;
        $this->description->doUpdate = $doUpdate;
        
    }

    
}
