<?php
class CFW_Common_ViewState{
	static $theInstance;
	var $data;
	var $secret;
	public function __construct(){
		$this->data = array();
		$this->theInstance = null;

		$secret = "opensesami";
	}
	public static function getInstance(){
		if(self::$theInstance == null){
			self::$theInstance = new Common_ViewState();
		}
		return self::$theInstance;
	}
	public function get($key){
		return $this->data[$key];
	}
	public function remove($key){
		unset($this->data[$key]);
	}
	public function set($key,$value){
		$this->data[$key] = $value;
	}
	function createHash($data){
		$serialized = serialize($data);
		$hash = hash_hmac("md5",$serialized,$this->secret);

		return $hash;
	}
	function encode($data){
		$value["data"] = $data;
		$value["hash"] = $this->createHash($data);

		return base64_encode(serialize($value));
	}
	function decode($str){
		$value = unserialize(base64_decode($str));
		return $value;
	}
	function render(){
		$tag = "<input type=\"hidden\" id=\"__ViewState\" name=\"__ViewState\" value=\"" . $this->encode($this->data) . "\" />";

		return $tag;
	}

	function processRequest(){
		if(array_key_exists("__ViewState",$_POST)){
			$value = $this->decode($_POST["__ViewState"]);

			$hash = $this->createHash($value["data"]);
			if($hash != $value["hash"]){
				var_dump($value["data"]);
				throw new Exception('invalid ViewState');
			}

			$this->data = $value["data"];
		}
	}


}