<?php
/**
 * EntityPropertyを表現するインターフェース.
 *
 * @author okada
 * @package CFW_Models
 */
interface  CFW_Models_IEntityProperty{

    /**
     * 定義されている全てのフィールドを得る
     * @return Array 定義済みフィールドのFieldPropertyの配列
     */
    function getFields();
    /**
     * 更新対象フィールドを得る
     * @return Array 定義済みフィールドのうち、doUpate == trueのFieldPropertyの配列
     */
    function getUpdateFields();
    /**
     * 主キーのリストを得る
     * @return Array 主キーのFieldProperty配列
     */
    function getPrimaryKeys();
    /**
     * IDentity列の定義を得る
     * @return CFW_FieldProperties_Abstract ID列として設定されているフィールドのFieldProperty
     */
    function getIdentityField();
    /**
     * このプロパティに定義されているエンティティなどの名前.
     * データベースの場合テーブル名
     * @return String
     */
    function getName();
    /**
     * このプロパティに定義されているエンティティなどの名前を設定する.
     * @param unknown_type $value
     * @return unknown_type
     */
    function setName($value);
    /**
     * エンティティに付けた別名を得る.
     * @return String
     */
    function getAlias();
    /**
     * エンティティに付ける別名を設定する.
     * @param String $value
     * @return none
     */
    function setAlias($value);

    /**
     * エンティティの全ての列に対する更新対象設定
     * @param boolean $doUpdate
     * @return none
     */
    function setDoUpdate($doUpdate = true);
    /**
     * エンティティ生成のためのクラス定義を得る
     * @return String クラス名
     */
    function getEntityClass();
    /**
     * 作成日フィールドの名前
     * @return unknown_type
     */
    function getCreatedAtField();
    /**
     * 更新日フィールドの名前
     * @return unknown_type
     */
    function getModifiedAtField();

}