<?php
Zend_Loader::loadClass("CFW_Data_Criteria");
/**
 * AMFで渡されたCriteriaをCFW_Data_Criteriaに展開する
 * @author okada
 * @package CFW_Amf
 * @subpackage CriteriaParser
 */
class CFW_Amf_Data_CriteriaParser{
    /**
     * @var CFW_Data_Criteria
     */
    var $criteria;
    /**
     * 展開主処理
     * @param unknown_type $c
     * @return unknown_type
     */
    public function parse($c){
        //テスト用ではある。受け取った条件を変換不要の場合
        if($c instanceof CFW_Data_Criteria){
            $this->criteria = $c;
            return $this->criteria;
        }
        $this->criteria = new CFW_Data_Criteria();
        if($c == null) return $this->criteria;
        $op  = "";
        foreach($c->where as $w){
            if(is_string($w)){
                $op = $w;
                continue;
            }
            Zend_Loader::loadClass($w->__amfClassName);

            if($w->__amfClassName == "CFW_Data_Criteria_ComplexCondition"){

                $this->criteria->addWhere($this->parseComplex($w),$op);
                continue;
            }
            if($w->__amfClassName == "CFW_Data_Criteria_ColumnValueCondition"){
                $this->criteria->addWhere($this->parseColumnValue($w),$op);
                continue;
            }
            if($w->__amfClassName == "CFW_Data_Criteria_StringValueCondition"){
                $this->criteria->addWhere($this->parseString($w),$op);
                continue;
            }
        }
        return $this->criteria;
    }
    /**
     * 複合条件を展開
     * @param $c
     * @return unknown_type
     */
    function parseComplex($c){
        $complex = new CFW_Data_Criteria_ComplexCondition();
        $op = "";
        foreach($c->_conditions as $w){
            if(is_string($w)){
                $op = $w;
                continue;
            }
            if($w->__amfClassName == "CFW_Data_Criteria_ComplexCondition"){
               $complex->add($this->parseComplex($w),$op);
                continue;
            }
            if($w->__amfClassName == "CFW_Data_Criteria_ColumnValueCondition"){
                $complex->add($this->parseColumnValue($w),$op);
                continue;
            }
            if($w->__amfClassName == "CFW_Data_Criteria_StringValueCondition"){
                $complex->add($this->parseString($w),$op);
                continue;
            }
        }
        return $complex;
    }
    /**
     * 列値条件を展開する
     * @param $c
     * @return unknown_type
     */
    function parseColumnValue($c){
        $columnValue = new CFW_Data_Criteria_ColumnValueCondition(
            $c->_name,
            $c->_parameters[0]->value,
            $c->_operator,
            $c->_modifier
        );
        return $columnValue;
    }
    /**
     * 文字列式展開
     * @param $c
     * @return unknown_type
     */
    function parseString($c){
        $parameters = array();
        foreach($c->_parameters as $p){
            $parameters[] = new CFW_Data_Parameter($p->name,$p->value);
        }
        $string  = new CFW_Data_Criteria_StringCondition(
            $c->_expression,
            parameters
        );
        return $string;

    }
}