<?php
/**
 * AMFリクエストに対するレスポンスを表現する.
 * <p>通常のAMFレスポンスに結果セットなどをセットしていると「異常ではないがエラー(データ検証結果など)を通知したい」場合にどうにもならない。このため通常の処理結果と</p>
 * <p><strong>使えるかどうか不明</strong></p>
 * @author okada
 * @package CFW_Amf
 */
class CFW_Amf_Response{
    /**
     * @var object AMFサービス実行結果
     */
    public $result;
    /**
     *
     * @var array 現在実行したメソッドから出力されるエラー(CFW_Error_Messageを使う)
     */
    public $errorMessages;

    /**
     * 構築
     * @param object $result クライアントに送る結果(処理結果)
     * @param array $errors エラーの詳細.CFW_Errorの配列
     * @return unknown_type
     */
    public function __construct($result = null,$errorMessages = array()){
        $this->result = $result;
        $this->errors= $errorMessages;
    }
    public function addErrorMessage($errorMessage){
        $this->errorMessages[] = $errorMessage;
    }

}