<?php
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_Auth_Provider");
Zend_Loader::loadClass("CFW_Auth_Hash");
/**
 * 認証機能生成
 * @author okada
 * @package CFW_Auth
 */
class CFW_Auth_ProviderFactory{
	/**
	 * 認証プロバイダー取得
	 * @return CFW_Auth_Provider
	 */
	public static function getProvider(){
		$config = CFW_Config_Configuration::getInstance("core");
		$authConfig = $config->auth;
		$providerName = $authConfig->provider;
        Zend_Loader::loadClass("$providerName");

		$provider = new $providerName();
		$storageName = $authConfig->storage;
        Zend_Loader::loadClass("$storageName");
		$storage = new $storageName();
		$provider->storage = $storage;
		$provider->config = $authConfig;

		$hash = CFW_Auth_Hash::getInstance($authConfig->hashMethod);
		$hash->config = $authConfig;
		$provider->hash = $hash;
		return $provider;
	}
}