<?php
/**
 * 十進型用フィールドプロパティ
 * @author okada
 * @package CFW_FieldProperties
 */
class CFW_FieldProperties_Decimal extends CFW_FieldProperties_Abstract{
	public $minValue = -99999999999999999;
	public $maxValue = 99999999999999999;
	public function __construct($spec = null){
		parent::__construct($spec);

		$m = CFW_Util_String::repeat("9",($this->precision - $this->scale));
		if ($this->scale > 0) {
			$m += ".".CFW_Util_String::repeat("9",$this->scale);
		}
		$min = floatval($m) * (-1);
		$max = floatval($m);
		$this->minValue = ($this->minValue < $min) ? $min : $this->minValue;
		$this->maxValue = ($this->maxValue > $max) ? $max : $this->maxValue;
	}
}