<?php
require_once "File/Util.php";
Zend_Loader::loadClass("CFW_Log_Logger");
Zend_Loader::loadClass("CFW_Log_LoggerFactory");
Zend_Loader::loadClass("CFW_Log_LogWriter");
Zend_Loader::loadClass("CFW_IO_FileSystem");
Zend_Loader::loadClass("Zend_Log_Writer_Stream");
Zend_Loader::loadClass("Zend_Log");


/**
 * デフォルトのログ出力実体
 * @author okada
 * @package CFW_Log
 */
class CFW_Log_DefaultLogWriter extends CFW_Log_LogWriter{

	/**
	 * ログ出力先
	 * @var Zend_Log_Writer
	 */
	private $log;

	public function __construct(){
		parent::__construct();
	}

	public function init($config) {

	    $fileSystem = CFW_IO_FileSystem::getInstance();
		$t = time();
		$logPath = CFW_Log_LoggerFactory::resolveName($config->path,$t);
        $baseName = CFW_Log_LoggerFactory::resolveName($config->base_name,$t);

		if(File_Util::isAbsolute($logPath)){
            $path = $fileSystem->createDirectory($logPath);
        }
        else{
        	$logPathFragment = split(addslashes(DS),$logPath);
            $path = $fileSystem->createDirectory(BASE_PATH, $logPathFragment);
        }
        $path = File_Util::buildPath(array($path,$baseName));
		$writer = new Zend_Log_Writer_Stream($path);

		$priorityFilter = new Zend_Log_Filter_Priority(intval($config->priority));
		$writer->addFilter($priorityFilter);

		$log = new Zend_Log();
		$log->addWriter($writer);

		$this->log = $log;
	}

	public function write($level, $userId, $moduleName, $methodName, $message) {
		$formattedMessage = "";
		if ($userId != "") {
			$formattedMessage .= $userId;
		}
		$formattedMessage .= "\t";
		if ($moduleName != "") {
			$formattedMessage .= $moduleName;
		}
		if ($methodName != "") {
			$formattedMessage .= "#".$methodName;
		}
		$formattedMessage .= "\t".$message;

		$this->log->log($formattedMessage, $level);
	}
}