<?php
Zend_Loader::loadClass("CFW_Acl_IRule");
Zend_Loader::loadClass("CFW_Acl_IResource");
Zend_Loader::loadClass("CFW_Acl_IRole");
Zend_Loader::loadClass("CFW_Acl_Rule");
Zend_Loader::loadClass("CFW_Acl_Resource");
Zend_Loader::loadClass("CFW_Acl_RuleEnumerator");
Zend_Loader::loadClass("CFW_Acl_Role");
Zend_Loader::loadClass("CFW_Acl_Privilege");
Zend_Loader::loadClass("CFW_Models_TreeNode");


/**
 * ACL本体
 * @author okada
 * @package CFW_Acl
 */
class CFW_Acl_AccessControl{
    /**
     * @var array
     */
    var $rules;
    /**
     * @var CFW_Acl_Resource
     */
    var $resources;
    /**
     * @var CFW_Acl_Role
     */
    var $roles;

    /**
     * @var array
     */
    var $resourceIndex;
    /**
     * @var array
     */
    var $roleIndex;

    /**
     * 構築.
     * @return unknown_type
     */
    public function __construct(){
        $this->resources= new CFW_Models_TreeNode();
        $this->roles = new CFW_Models_TreeNode();
        $this->rules = array();
        $this->resourceIndex = array();
        $this->roleIndex= array();

    }
    /**
     * ロールを追加する.
     * @param unknown_type $roleName
     * @param unknown_type $parentName
     * @return unknown_type
     */
    public function addRole($roleName,$parentName = null){
        $parent = null;
        if($parentName == null){
            $parent = $this->roles;
        }
        else{
            $parent = $this->roles->find($this->roleIndex[$parentName]);
        }
        $role = new CFW_Acl_Role($roleName);
        $parent->appendChild($role);
        //インデックス構築
        $this->roleIndex[$roleName] = $role->path();
    }
    /**
     * リソースを追加する
     * @param unknown_type $resourceName
     * @param unknown_type $parentName
     * @return unknown_type
     */
    public function addResource($resourceName,$parentName = null){
        $parent = null;
        if($parentName == null){
            $parent = $this->resources;
        }
        else{
            $parent = $this->resources->find($this->resourceIndex[$parentName]);
        }
        $resource = new CFW_Acl_Resource($resourceName);
        $parent->appendChild($resource);
        //インデックス構築(指定された名前に対してパス情報の配列を保存する)
        $this->resourceIndex[$resourceName] = $resource->path();
    }
    /**
     * ルールを追加する
     * @param unknown_type $resourceName
     * @param unknown_type $roleName
     * @param unknown_type $privilege
     * @return unknown_type
     */
    public function addRule($resourceName,$roleName,$privilege = CFW_Acl_Privilege::ALL){
        $resource = $this->resources->find($this->resourceIndex[$resourceName]);
        $role = $this->roles->find($this->roleIndex[$roleName]);

        $rule = new CFW_Acl_Rule();
        $rule->setResourceName($resourceName);
        $rule->setRoleName($roleName);
        $rule->setPrivilege($privilege);

        $this->rules[] = $rule;
    }


	/**
	 * 指定条件が許可されているかチェックする.
	 *
	 * @param unknown_type $resourceName
	 * @param unknown_type $privilege
	 * @param unknown_type $roles
	 * @return string|string
	 */
	public function isAllowed($resourceName,$privilege,$roles){
        $normalizedRoles = $this->normalizeRoles($roles);

        $resource = $this->findResource($resourceName);
        //リソースを登録していなければ「アクセス制御されていない」= だれでも何でもできる。
        if ($resource == null) return true;
        $allow = false;
        $ruleExists = false;
        //指定されたロール全てについてルールを検索して許可されているルールを見つける
        foreach($normalizedRoles as $role){
            //指定リソースから根元方向にリソースツリーをたどり、許可されているルールを見つける
            $resourceNode = $resource;
            while ($resourceNode != null)
            {
                //指定ロールから根元方向にリソースツリーをたどり、許可されているルールを見つける
                $roleNode = $role;
                while ($roleNode != null)
                {
                    $resourceRules = new CFW_Acl_RuleEnumerator($this->rules, $resourceNode);
                    while ($resourceRules->next())
                    {
                        $rule = $resourceRules->current();
                        //直接指定されているルールがあれば採用
                        if ($rule->getRoleName() == $roleNode->getName())
                        {
                            $ruleExists = true;
                            $allow = $rule->isAllowed($privilege);
                            break;
                        }
                    }

                    if ($ruleExists) break;
                    $roleNode = $roleNode->getParent();
                }

                if ($ruleExists) break;
                $resourceNode = $resourceNode->getParent();
            }
            if ($ruleExists)
            {
                if ($allow) break; //どこかで許可されてたら他で拒否されていても許可
            }
        }
        return $allow;
	}
	/**
	 * 指定条件が拒否されているかチェックする.
	 * @param unknown_type $resourceName
	 * @param unknown_type $privilege
	 * @param unknown_type $roles
	 * @return boolean
	 */
	public function isDenied($resourceName,$privilege,$roles){
        return !$this->isAllowed($resourceName,$privilege,$roles);
	}
	/**
	 * 渡されたロールに重複などがないよう整理する.
	 * @param unknown_type $roles
	 * @return Ambigous <unknown, multitype:>
	 */
	public function normalizeRoles($roles){
	    $normalized = array();
        foreach ($roles as $role)
        {
            //現在の$roleの子供がもとの$rolesにない時だけ正規のリストに追加する
            $hasChild = false;
            foreach($roles as $subRole){
                if($subRole->IsDescendantOf($role)){
                    $hasChild = true;
                    break;
                }
            }
            if(!$hasChild){
                $normalized[] = $role;
            }
        }
        return $normalized;
	}
	/**
	 * 登録されているリソースオブジェクトを検索する
	 * @param unknown_type $resourceName
	 * @return unknown
	 */
	public function findResource($resourceName){
	   $key = $this->resourceIndex[$resourceName];
	   $resource = $this->resources->find($key);
	   return $resource;
	}
    /**
     * 登録されているロールオブジェクトを検索する
     * @param unknown_type $roleName
     * @return unknown
     */
    public function findRole($roleName){
       $key = $this->roleIndex[$roleName];
       $role = $this->roles->find($key);
       return $role;
    }
    /**
     * 外部に保存しているACLデータを読み込む.
     * サブクラスでの実装が必要
     * @return unknown_type
     */
    public function load(){

    }
}