<?php
/**
 * Criteria Test
 * 間違い
 */
include("../../core.php");

class Element{
    
}
class OperatorElement extends Element{
    const OP_AND = "&";
    const OP_OR = "|";
    const OP_NOT = "!";
    const OP_EQ = "=";
    const OP_EQR = "~=";
    const OP_GE = ">=";
    const OP_LE = "<=";
    
    var $op;
    
    public function __construct($op){
        $this->op = $op;
    }
    
}
class ExpressionElement extends Element{
    var $expr;
    public function __construct($expr){
        $this->expr = $expr;
    }
}
class ComplexElement extends Element{
    var $expr;
    public function __construct($expr){
        $this->expr = $expr;
    }
}

class Filter{
    var $filters;

    public function __construct(){
        $this->filters = array();
    }
    public function parse(ArrayIterator &$iterator){
        while($iterator->valid())
        {
            $iterator->next();
            $comp = new FilterComponent();
            $this->filters[] = $comp->parse($iterator);
            
        }
        
        return $this;
    }
    public function dump(){
        return "(" . $this->filterComponent->dump() . ")";
    }
    
}
class FilterList{
    var $filters;
    
    public function parse(ArrayIterator &$iterator){
        $element = $iterator->current();
        if ($element instanceof ExpressionElement){
            $expr = new FilterSimpleComponent();
            $this->filters[] = $expr->parse($iterator);
        }
        if ($element instanceof OperatorElement){
            $expr = new FilterComponent();
            $this->filters[] = $expr->parse($iterator);
        }
        else{
            $it = new ArrayIterator(new ArrayObject($element->expr));
            
            $expr = new Filter();
            $this->filter[] = $expr->parse($it);
        }
        $iterator->next();
        
        return $this;
        
    }
    public function dump(){
        $s = "";
        foreach($this->filters as $filter){
            $s .= $filter->dump();
        }
    }
}
class FilterComponent{
    var $component;
    
    public function parse(ArrayIterator &$iterator){
        $element = $iterator->current();
        if($element instanceof OperatorElement){
            $iterator->next();
            if($element->op == OperatorElement::OP_AND){
                $comp = new FilterAndComponent();
                $this->component = $comp->parse($iterator);
            }
            if($element->op == OperatorElement::OP_OR){
                $comp = new FilterOrComponent();
                $this->component = $comp->parse($iterator);
                            }
            if($element->op == OperatorElement::OP_NOT){
                $comp = new FilterNotComponent();
                $this->component = $comp->parse($iterator);
                                
            }
        
        }
        else{
            
            //simple
            $comp = new FilterSimpleComponent();
            $this->comp = $comp->parse($iterator);
        }
        return $this;
        
    }
    public function dump(){
        return $this->component->dump();
    }
}
class FilterOrComponent{
    var $filterList;
    
    public function parse(ArrayIterator &$iterator){
        $iterator->next();
        $list = new FilterList();
        $this->filterList =$list->parse($iterator);         
        $iterator->next();
        return $this;
    }
    public function dump(){
        return "|" . $this->filterList->dump() ;
    }
}
class FilterAndComponent{
    var $filterList;
    
    public function parse(ArrayIterator &$iterator){
        $iterator->next();
        $list = new FilterList();
        $this->filterList =$list->parse($iterator);         
        $iterator->next();
        return $this;
        
    }
    public function dump(){
        return "&" . $this->filterList->dump() ;
        
    }
}
class FilterNotComponent{
    var $filter;
    public function parse(ArrayIterator &$iterator){
        $iterator->next();
        $filter = new Filter();
        $this->filterList =$filter->parse($iterator);         
        
        $iterator->next();
        return $this;
    }
    public function dump(){
        return "!" . $this->filterList->dump() ;
        
    }
}
class FilterSimpleComponent{
    /**
     * 式
     * 
     * a=b,a=*,a<=d etc...
     * @var unknown_type
     */
    var $expr; 
    public function parse(ArrayIterator &$iterator){
        $expr = $iterator->current();
        $this->expr = $expr->expr;
        $iterator->next();
        return $this;
    }
    public function dump(){
        return "(" . $this->expr . ")" ;
        
    }
}

$elements = array();
$elements[] = new ExpressionElement( "a=b" );

$elements[] = new OperatorElement(OperatorElement::OP_OR);
$elements[] = new ExpressionElement( "c=d" );

$elements[] = new OperatorElement(OperatorElement::OP_AND);
$elements[] = new ExpressionElement( "e=f" );

$elements[] = new OperatorElement(OperatorElement::OP_OR);
$elements[] = new ExpressionElement( "g=h" );
// (|(a=b)(&(c=d)(e=f))(g=h))
$arr= new ArrayObject($elements);
$iterator = $arr->getIterator();


$filter = new Filter();
$result = $filter->parse($iterator);

echo $result->dump();

?>