<?php
include( "../core.php" );

/**
 * 再帰下降型
 * NUM -> VARにしてみた
 * @author okada
 *
 */

class Pair{
    var $value;
    var $p;
    public function __construct($v,$p){
        $this->value = $v;
        $this->p = $p;
    }
    
}

class Parser{
    var $result;
    public function parse($s){
        $this->result = $this->equation($s,0);
        
    }
    
    function equation($s, $p= 0) {
      $r = $this->factor($s, $p);
      while (substr($s,$r->p,1) == '+') {
        $r_ = $this->factor($s, $r->p+1);
        $r->value += $r_->value;
        $r->p      = $r_->p;
      }
      return $r;
    }
    
    function factor($s, $p) {
      $r = $this->term($s, $p);
      while (substr($s,$r->p,1) == '*') {
        $r_ = $this->term($s, $r->p+1);
        $r->value *= $r_->value;
        $r->p      = $r_->p;
      }
      return $r;
    }
    function term($s,  $p) {
      if (substr($s,$p,1) == '(') {
        $r = $this->equation($s, $p+1);
        $r->p += 1; // skip ')'
        return $r;
      } else {
        $value = 0;
        $d = substr($s,$p,1);
        while(is_numeric($d)){        
            $n = intval($d);
            $value = $value * 10 + $n;
            
            $p++;
            if($p >= strlen($s)) break;
            $d = substr($s,$p,1);
            
        }
        return new Pair($value, $p);
      }
    }
    
}

$parser = new Parser();
$parser->parse("1+2*3");
echo "-----<br />";
echo "result = " . $parser->result->value. "<br />";
echo "-----<br />";

?>