<?php

/**
 * ハッシュ関数の抽象
 * @author okada
 * @package CFW_Auth
 */
abstract class CFW_Auth_Hash{
    /**
     *
     * @var CFW_Config_Configuration
     */
    var $config;
    /**
     * 設定に基づくクラスを取得
     * @param unknown_type $method
     * @return CFW_Auth_Hash
     */
    public static function getInstance($method = "PLAINTEXT"){
          if ($method == "MD5")
            {
                Zend_Loader::loadClass("CFW_Auth_Hash_Md5");
                return new CFW_Auth_Hash_Md5();
            }
            if ($method == "SHA1")
            {
                Zend_Loader::loadClass("CFW_Auth_Hash_Sha1");
                return new CFW_Auth_Hash_Sha1();
                            }
            if ($method == "SMD5")
            {
                Zend_Loader::loadClass("CFW_Auth_Hash_Smd5");
                return new CFW_Auth_Hash_Smd5();
                            }
            if ($method == "SSHA1")
            {
                Zend_Loader::loadClass("CFW_Auth_Hash_SSha1");
                return new CFW_Auth_Hash_SSha1();
            }

            Zend_Loader::loadClass("CFW_Auth_Hash_Default");
            return new CFW_Auth_Hash_Default();

    }
    /**
     * 新しいハッシュを作る.
     * @param unknown_type $input
     * @return unknown_type
     */
    public abstract function createHash($input);
    /**
     * 入力値のハッシュ結果が元の値になるか検証
     * @param unknown_type $input
     * @param unknown_type $target
     * @return unknown_type
     */
    public abstract function verify($input,$target);
    /**
     * エンコードする
     * @param unknown_type $original
     * @return unknown_type
     */
    public function encode($original)
    {

        $method = $this->config->encode;

        if ($method == "BASE64")
        {
            return base64_encode($original);
        }
        if ($method == "HEX")
        {
            return bin2hex ($original);
        }
        if ($method == "PLAIN")
        {
            return $original;

        }
        return "";
    }
    /**
     * 入力文字のデコード
     * @param $original 入力文字
     * @return unknown_type デコード結果のバイト配列
     */
    public function decode($original)
    {
        $method  = $this->config->encode;
        if ($method == "BASE64")
        {
            return base64_decode($original);
        }
        if ($method == "HEX")
        {
            return pack("H*",$original);
        }
        if ($method == "PLAIN")
        {
            return $original;

        }
        return $original;
    }

}