<?php
Zend_Loader::loadClass("CFW_Log_LoggerFactory");
Zend_Loader::loadClass("CFW_Log_Logger");
Zend_Loader::loadClass("CFW_Auth_NullUser");

/**
 * 認証機能の基本
 *
 * 実際のアプリケーションはこのクラスを継承したサブクラスを作成し、loadIdentity(Identityの生成情報読み込み)とverify(ログインID,パスワードの検証)をオーバーライドして使う。
 *
 * たとえばこのように
 * <code>
 * class HogeAuthProvider extends CFW_Auth_Provider{
 *   public function loadIdentity($userId,$password){
 *       $identity = new CFW_Auth_Identity();
 *       $identity->name = $userId;
 *       $user = new CFW_Auth_NullUser();
 *       $user->setId($userId);
 *       $user->setName($userId);
 *       $identity->user = $user;
 *       $identity->roles = array();
 *       return $identity;
 *   }
 *   function verify($userId,$password){
 *       return ($userId == "testuser" && $password=="password1");
 *   }
 *
 * }
 * </code>
 *
 * 使用時にはcore.iniに実装クラス、ID情報保持クラス、パスワード保存方法などを設定し、CFW_Auth_Provider#getProvider()により認証機能本体を得る。
 *
 * 設定サンプル
 * <code>
 * auth.provider = CFW_Auth_NullAuthProvider
 * auth.storage = CFW_Auth_SessionStorage
 * auth.hashMethod = SMD5
 * auth.saltLength = 8
 * auth.encode = BASE64
 * </code>
 *
 * @author okada
 * @package CFW_Auth
 */
class CFW_Auth_Provider{


	/**
	 * 認証情報保持
	 * @var CFW_Auth_Storage
	 */
	var $storage;
	/**
	 * 設定
	 * @var Zend_Config
	 */
	var $config;
	/**
	 * ハッシュ関数
	 * @var CFW_Auth_Hash
	 */
	var $hash;
	
	/**
	 * ログ出力
	 * @var CFW_Log_Logger
	 */
	private $logger;
	
	public function __construct(){
		$this->logger = CFW_Log_LoggerFactory::getLogger("cfw_debug",__CLASS__);
		
	}
	/**
	 * 認証処理
	 * @param unknown_type $userId
	 * @param unknown_type $password
	 * @return boolean
	 */
	public function authenticate($userId,$password){
		$this->logger->log(CFW_Log_Level::DEBUG,__FUNCTION__,"start",new CFW_Auth_NullUser());
		
		if($this->verify($userId,$password)){
			$identity = $this->loadIdentity($userId,$password);
			$this->storage->saveIdentity($identity);

			$this->logger->log(CFW_Log_Level::DEBUG,__FUNCTION__,"end",new CFW_Auth_NullUser());
			return true;
		}
		$this->logger->log(CFW_Log_Level::DEBUG,__FUNCTION__,"end",new CFW_Auth_NullUser());
		return false;

	}
	/**
	 * identity読み込み
	 * @param unknown_type $id
	 * @param unknown_type $password
	 * @return unknown_type
	 */
	public function loadIdentity($userId,$password){

	}
	/**
	 * IDとパスワードの検証
	 * @param unknown_type $id
	 * @param unknown_type $password
	 * @return unknown_type
	 */
	function verify($userId,$password){

	}
	/**
	 * @return unknown_type
	 */
	public function isAuthenticated(){
		return $this->storage->isAuthenticated();
	}
	/**
	 * identityを取得
	 * @return unknown_type
	 */
	public function getIdentity(){
		return $this->storage->getIdentity();
	}
	/**
	 * ログアウト
	 * @return unknown_type
	*/
	public function logout(){
		$this->storage->removeIdentity();
	}
}