<?php

/**
 * ページング
 * 
 * 
 * [experimental]
 * @author okada
 *
 */
class CFW_Html_Pagenator{
	public $id;
	public $url;
	public $limit;
	public $offset;
	public $total;

	public function render(){
		$numPages = $this->total / $this->limit + ($this->total % $this->limit > 0 ? 1 : 0) ;
		$currentPage = $this->offset / $this->limit;
		$from = 0;
		$to = 5;
		if($currentPage > 2){
			$from = $currentPage - 2;
			$to = $from + 5;
		}
		if($to > ($numPages - 2)){
			$to = $numPages ;
			
		}
		
		$html = "<div id=\"{$this->id}\" class=\"pagenator\">";
		for($i = $from;$i < $to;$i++){
			$o = $i * $this->limit;
			$p = $i + 1;
			$a = "";
			if($i == $currentPage){
			$a = "<span>{$p}</span>";
				
			}
			else{
				$a = "<span><a href=\"{$this->url}?offset={$o}&limit={$this->limit}\" >{$p}</a></span>";
				
			}
			$html .= $a;
		}
		
		$html .= "</div>";
		return $html;
	}
	
	public static function create($id,$url,$total,$limit,$offset){
		$pagenator = new CFW_Html_Pagenator();
		$pagenator->id = $id;
		$pagenator->url = $url;
		$pagenator->total = $total;
		$pagenator->limit = $limit;
		$pagenator->offset = $offset;
		
		return $pagenator->render();
	}
}