<?php
Zend_Loader::loadClass("CFW_FieldValidators_Abstract");
Zend_Loader::loadClass("CFW_FieldProperties_Abstract");
/**
 * エンティティ検証
 * @author okada
 * @package CFW_Models
 */
class CFW_Models_Validator{
        /**
         * 検証対象のエンティティ
         * @var unknown_type
         */
        var $target;
        /**
         * 検証対象のプロパティ
         * @var unknown_type
         */
        var $property;
        /// <summary>
        ///
        /// </summary>
        /**
         * 検証中に発生したメッセージ
         * @var unknown_type
         */
        var $messages;
        /// <summary>
        ///
        /// </summary>
        /**
         * 基本構築
         * @param $entity 検証対象
         * @param $property 対象の構造
         * @return unknown_type
         */
        public function __construct($entity,$property)
        {
            $this->target = $entity;
            $this->property = $property;
            $this->messages= array();
        }
        /**
         * リセット
         * @return unknown_type
         */
        public function reset()
        {
            $this->messages = array();
        }
        /**
         * 検証本体
         * @return unknown_type validならtrue
         */
        public function validate()
        {
            $valid = true;
            $fields = $this->property->GetFields();
            foreach($fields as $field){
                $validator = CFW_FieldValidators_Abstract::getInstance($field);
                if (!$validator->validate($this->target->getValue($field->fieldName)))
                {
                    $this->messages[] = $validator->message;
                    $valid = false;
                }

            }
           return $valid;
        }

}