<?php
require_once("Zend/Cache.php");
/**
 * Zend_Cacheのショートカットクラス
 * @author okada
 * @package CFW_Util
 */
class CFW_Util_Cache{
    /**
     * キャッシュ持続時間のデフォルト
     * @var int
     */
    static $lifetime = 3600;
    /**
     * 指定したオプションでキャッシュオブジェクトを作る
     * @param array $option
     * @return Zend_Cache
     */
    public static function factory($option = array()){
        if(!array_key_exists("lifetime",$option)){
            $option["lifetime"] = self::$lifetime;
        }
        $frontendOptions = array(
            'lifetime' => $option["lifetime"],
            'automatic_serialization' => true
        );

        $backendOptions = array(
            'cache_dir' => $option["path"] // キャッシュファイルを書き込むディレクトリ
        );

        // Zend_Cache_Core オブジェクトを取得します
        $cache = Zend_Cache::factory('Core',
                                     'File',
                                     $frontendOptions,
                                     $backendOptions);

        return $cache;
    }
}
