<?php
Zend_Loader::loadClass("CFW_FieldProperties_Abstract");
Zend_Loader::loadClass("CFW_Models_EntityProperty");

/**
* table acl_rolesに対応するフィールドプロパティ
*/
class CFW_Acl_Db_Models_Base_AclRolesTableProperty extends  CFW_Models_EntityProperty
{
    /* var CFW_FieldProperties_Abstract [id] */
    public $id;
    /* var CFW_FieldProperties_Abstract [name] */
    public $name;
    /* var CFW_FieldProperties_Abstract [left_side] */
    public $leftSide;
    /* var CFW_FieldProperties_Abstract [right_side] */
    public $rightSide;
    /* var CFW_FieldProperties_Abstract [description] */
    public $description;
    /* var CFW_FieldProperties_Abstract [deleted] */
    public $deleted;
    /* var CFW_FieldProperties_Abstract [created_at] */
    public $createdAt;
    /* var CFW_FieldProperties_Abstract [modified_at] */
    public $modifiedAt;
    

    /**
    * default construct
    */
    public function __construct()
    {
        $this->entityName = "acl_roles";
        $this->id =  CFW_FieldProperties_Abstract::newInstance("int", "acl_roles", "id","[id]", 4, 10, 0, false, 0,true);
        $this->name =  CFW_FieldProperties_Abstract::newInstance("varchar", "acl_roles", "name","[name]", 100, 100, 0, false, "",false);
        $this->leftSide =  CFW_FieldProperties_Abstract::newInstance("int", "acl_roles", "left_side","[left_side]", 4, 10, 0, false, 0,false);
        $this->rightSide =  CFW_FieldProperties_Abstract::newInstance("int", "acl_roles", "right_side","[right_side]", 4, 10, 0, false, 0,false);
        $this->description =  CFW_FieldProperties_Abstract::newInstance("varchar", "acl_roles", "description","[description]", 500, 500, 0, true, "",false);
        $this->deleted =  CFW_FieldProperties_Abstract::newInstance("int", "acl_roles", "deleted","[deleted]", 4, 10, 0, false, 0,false);
        $this->createdAt =  CFW_FieldProperties_Abstract::newInstance("datetime", "acl_roles", "created_at","[created_at]", 16, 23, 3, false, null,false);
        $this->modifiedAt =  CFW_FieldProperties_Abstract::newInstance("datetime", "acl_roles", "modified_at","[modified_at]", 16, 23, 3, false, null,false);
        

        $this->entityClass = "CFW_Acl_Db_Models_Base_AclRolesTableRow";
         
    }

    /**
    * 全てのフィールドを列挙
    * 
    * @returns 
    */
    public function getFields()
    {
        $fields = array();
        $fields[] = $this->id;
        $fields[] = $this->name;
        $fields[] = $this->leftSide;
        $fields[] = $this->rightSide;
        $fields[] = $this->description;
        $fields[] = $this->deleted;
        $fields[] = $this->createdAt;
        $fields[] = $this->modifiedAt;
        
        return $fields;
    }
    /**
    * 全ての主キーを列挙
    * 
    * @returns 
    */
    public function getPrimaryKeys()
    {
        $fields = array();
        $fields[] = $this->id;
        
        return $fields;
    }
    public function getUpdateFields(){
        $fields = array();
        if($this->id->doUpdate && !$this->id->isIdentity)$fields[] = $this->id;
        if($this->name->doUpdate && !$this->name->isIdentity)$fields[] = $this->name;
        if($this->leftSide->doUpdate && !$this->leftSide->isIdentity)$fields[] = $this->leftSide;
        if($this->rightSide->doUpdate && !$this->rightSide->isIdentity)$fields[] = $this->rightSide;
        if($this->description->doUpdate && !$this->description->isIdentity)$fields[] = $this->description;
        if($this->deleted->doUpdate && !$this->deleted->isIdentity)$fields[] = $this->deleted;
        if($this->createdAt->doUpdate && !$this->createdAt->isIdentity)$fields[] = $this->createdAt;
        if($this->modifiedAt->doUpdate && !$this->modifiedAt->isIdentity)$fields[] = $this->modifiedAt;
        
        return $fields;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setDoUpdate($doUpdate)
     */
    public function setDoUpdate($doUpdate = true){
        $this->id->doUpdate = $doUpdate;
        $this->name->doUpdate = $doUpdate;
        $this->leftSide->doUpdate = $doUpdate;
        $this->rightSide->doUpdate = $doUpdate;
        $this->description->doUpdate = $doUpdate;
        $this->deleted->doUpdate = $doUpdate;
        $this->createdAt->doUpdate = $doUpdate;
        $this->modifiedAt->doUpdate = $doUpdate;
        
    }

    
}
