<?php
/**
 * 文字列用フィールドプロパティ
 * @author okada
 * @package CFW_FieldProperties
 */
class CFW_FieldProperties_String extends CFW_FieldProperties_Abstract{
	/**
	 * 最大長
     *
	 * useWideChar == trueのときは文字数、そうでなければ文字幅。
	 * @var unknown_type
	 */
	public $maxLength;
	/**
	 * 最小長
     *
     * useWideChar == trueのときは文字数、そうでなければ文字幅。
	 * @var unknown_type
	 */
	public $minLength;
	/**
	 * ワイド文字を使うか。
	 *
	 * nchar,nvarchar対応。
	 * @var boolean
	 */
	public $useWideChar;
	public function __construct($spec = null){
		parent::__construct($spec);
		$this->minLength = 0;
		$this->maxLength = intval( $this->precision );
		$this->useWideChar = false;
	}
}