<?php
/**
 * double用
 * @author okada
 * @package CFW_FieldValidators
 */
class CFW_FieldValidators_Double extends CFW_FieldValidators_Abstract{
    /* (non-PHPdoc)
     * @see library/CFW/FieldValidators/CFW_FieldValidators_Abstract#validateRange($value)
     */
    public function validateRange( $value)
    {
        $this->message = "";
        $property = $this->property;

        if ( $value < $property->minValue || $value > $property->maxValue)
        {
            $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_INVALID_RANGE"),$this->property->displayName,$this->property->minValue ,$this->property->maxValue);
            return false;
        }
        return true;
    }
    /**
     *      * @param $value
     */
    public function validateType($value){
        if($value == null) return true;
        if(!is_numeric( $value)){
            $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_INVALID_FORMAT"),$this->property->displayName);
            return false;
        }
        return true;
    }
    public function validateFormat($value){
        if($value == null) return true;
        $s = str_replace("-", "", strval($value));
        $n1 = "";
        $n2 = "";
        $a = explode(".",$s);
        $n1 = $a[0];
        if(count($a)>1){
            $n2 = $a[1];
        }
        if(strlen($n1 . $n2) > $this->property->precision){
            $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_INVALID_FORMAT"),$this->property->displayName);
            return false;
        }
        /*
         * 本来scaleはnullであるが、特別に設定された場合を考えて
         * 何か設定されていたら小数点以下がscaleより長い場合エラーとする。
         */
        if($this->property->scale > 0){
            if(strlen($n2) > $this->property->scale){
                $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_INVALID_FORMAT"),$this->property->displayName);
                return false;
            }            
            if(strlen($n1) > ($this->property->precision - $this->property->scale)){
                $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_INVALID_FORMAT"),$this->property->displayName);
                return false;
            }            
        }
        
        return true;
    }
    
}