<?php
/**
 * varchar|text用
 * @author okada
 * @package CFW_FieldValidators
 */
class CFW_FieldValidators_String extends CFW_FieldValidators_Abstract{
    /* (non-PHPdoc)
     * @see library/CFW/FieldValidators/CFW_FieldValidators_Abstract#validateLength($value)
     */
    public function validateLength($value)
    {
        $length = 0;
        if($this->property->useWideChar){
            $length = mb_strlen($value);
        }
        else{
            $length = mb_strwidth($value);

        }

        if($length > $this->property->maxLength){
            $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_INVALID_RANGE"),$this->property->displayName,$this->property->minLength,$this->property->maxLength);
            return false;
        }
        if($length < $this->property->minLength){
            $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_INVALID_RANGE"),$this->property->displayName,$this->property->minLength,$this->property->maxLength);
            return false;
        }
        return true;
    }
    public function validateType($value){
        if($value == null) return true;
        if(!is_string($value)){
            $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_INVALID_FORMAT"),$this->property->displayName);
            return false;
        }
        return true;
    }
    public function validateFormat($value){
        if($value == null) return true;
        if(mb_ereg_match($this->property->format,$value) === false){
            $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_INVALID_FORMAT"),$this->property->displayName);
            return false;
        }
        return true;
    }
    
}